/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.constraint.impl;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.seasar.ymir.Request;
import org.seasar.ymir.constraint.ConstraintUtils;
import org.seasar.ymir.constraint.ConstraintViolatedException;
import org.seasar.ymir.constraint.ValidationFailedException;
import org.seasar.ymir.constraint.annotation.Required;
import org.seasar.ymir.constraint.impl.AbstractConstraint;
import org.seasar.ymir.message.Note;
import org.seasar.ymir.message.Notes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredConstraint
extends AbstractConstraint<Required> {
    @Override
    protected String getConstraintKey() {
        return "required";
    }

    @Override
    public void confirm(Object component, Request request, Required annotation, AnnotatedElement element) throws ConstraintViolatedException {
        String fullMessageKey = this.getFullMessageKey(annotation.messageKey());
        Notes notes = new Notes();
        if (annotation.matchedParameterRequired()) {
            String[] patterns;
            for (String pattern : patterns = this.getNotMatchedPatterns(request, annotation.value())) {
                notes.add(pattern, new Note(fullMessageKey, annotation.namePrefixOnNote() + pattern));
            }
        }
        String[] names = this.getParameterNames(request, this.getPropertyName(element), annotation.value());
        if (notes.isEmpty() && names.length == 0) {
            return;
        }
        for (String name : names) {
            if (!ConstraintUtils.isEmpty(request, name, annotation.completely(), annotation.allowWhitespace(), annotation.allowFullWidthWhitespace())) continue;
            notes.add(name, new Note(fullMessageKey, annotation.namePrefixOnNote() + name));
        }
        if (notes.size() > 0) {
            throw new ValidationFailedException().setNotes(notes);
        }
    }

    String[] getNotMatchedPatterns(Request request, String[] names) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].startsWith("#")) continue;
            Pattern pattern = Pattern.compile(names[i].substring("#".length()));
            boolean matched = false;
            Iterator<String> itr = request.getParameterNames();
            while (itr.hasNext()) {
                String name = itr.next();
                if (!pattern.matcher(name).matches()) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            list.add(names[i]);
        }
        return list.toArray(new String[0]);
    }
}

