/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.extension.creator.action.impl;

import java.lang.reflect.Type;
import java.util.Map;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.extension.creator.ClassDesc;
import org.seasar.ymir.extension.creator.DescPool;
import org.seasar.ymir.extension.creator.InvalidClassDescException;
import org.seasar.ymir.extension.creator.MethodDesc;
import org.seasar.ymir.extension.creator.PathMetaData;
import org.seasar.ymir.extension.creator.SourceCreator;
import org.seasar.ymir.extension.creator.action.UpdateAction;
import org.seasar.ymir.extension.creator.action.impl.AbstractAction;
import org.seasar.ymir.extension.creator.impl.BodyDescImpl;
import org.seasar.ymir.extension.creator.mapping.impl.ActionSelectorSeedImpl;

public class CreateClassAction
extends AbstractAction
implements UpdateAction {
    private static final String PARAM_TRANSITION = "__ymir__transition";
    private static final String PARAM_TRANSITIONREDIRECT = "__ymir__transition_redirect";

    public CreateClassAction(SourceCreator sourceCreator) {
        super(sourceCreator);
    }

    public Response act(Request request, PathMetaData pathMetaData) {
        if (this.isSkipButtonPushed(request)) {
            return null;
        }
        String subTask = request.getParameter("__ymir__subTask");
        if ("create".equals(subTask)) {
            return this.actCreate(request, pathMetaData);
        }
        return this.actDefault(request, pathMetaData);
    }

    Response actDefault(Request request, PathMetaData pathMetaData) {
        String path = pathMetaData.getPath();
        HttpMethod method = request.getMethod();
        String actionName = this.getSourceCreator().newActionMethodDesc(this.newDescPool(), path, method, new ActionSelectorSeedImpl()).getName();
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("pathMetaData", pathMetaData);
        variableMap.put("actionName", actionName);
        return this.getSourceCreator().getResponseCreator().createResponse("createClass", variableMap);
    }

    Response actCreate(Request request, PathMetaData pathMetaData) {
        HttpMethod method = this.getHttpMethod(request);
        if (method == null) {
            return null;
        }
        String transition = request.getParameter(PARAM_TRANSITION);
        boolean redirect = "true".equals(request.getParameter(PARAM_TRANSITIONREDIRECT));
        this.updateMapping(pathMetaData);
        DescPool pool = this.newDescPool();
        String path = pathMetaData.getPath();
        pool.setBornOf(path);
        ClassDesc classDesc = this.getSourceCreator().newClassDesc(pool, pathMetaData.getClassName(), null);
        MethodDesc actionMethodDesc = this.getSourceCreator().newActionMethodDesc(pool, path, method, new ActionSelectorSeedImpl());
        actionMethodDesc.setReturnTypeDesc((Type)((Object)String.class));
        actionMethodDesc.getReturnTypeDesc().setExplicit(true);
        if (transition != null && transition.trim().length() > 0) {
            if (redirect) {
                transition = "redirect:" + transition;
            }
            actionMethodDesc.setBodyDesc(new BodyDescImpl("return " + this.quote(transition.trim()) + ";", new String[0]));
        }
        classDesc.setMethodDesc(actionMethodDesc);
        String[] lackingClassNames = null;
        try {
            this.getSourceCreator().updateClass(classDesc);
        }
        catch (InvalidClassDescException ex) {
            lackingClassNames = ex.getLackingClassNames();
        }
        boolean successfullySynchronized = this.synchronizeResources(new String[]{this.getRootPackagePath()});
        this.pause(1000L);
        this.openJavaCodeInEclipseEditor(pathMetaData.getClassName());
        Map<String, Object> variableMap = this.newVariableMap();
        variableMap.put("request", request);
        variableMap.put("method", method);
        variableMap.put("parameters", this.getParameters(request));
        variableMap.put("pathMetaData", pathMetaData);
        variableMap.put("lackingClassNames", lackingClassNames);
        variableMap.put("successfullySynchronized", successfullySynchronized);
        return this.getSourceCreator().getResponseCreator().createResponse("createClass_create", variableMap);
    }
}

