/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.gson;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.kvasir.util.io.IORuntimeException;
import org.seasar.kvasir.util.io.IOUtils;
import org.seasar.ymir.Action;
import org.seasar.ymir.ActionManager;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.MethodInvoker;
import org.seasar.ymir.MethodInvokerWrapper;
import org.seasar.ymir.PageComponent;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.WrappingRuntimeException;
import org.seasar.ymir.gson.annotation.JSONResponse;
import org.seasar.ymir.gson.util.JSON;
import org.seasar.ymir.interceptor.impl.AbstractYmirProcessInterceptor;

public class GsonInterceptor
extends AbstractYmirProcessInterceptor {
    private ActionManager actionManager_;
    private ApplicationManager applicationManager_;
    private ThreadLocal<String> rawJson_ = new ThreadLocal();
    private static final Set<String> CONTENT_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("text/javascript", "application/json")));

    @Binding(bindingType=BindingType.MUST)
    public void setActionManager(ActionManager actionManager) {
        this.actionManager_ = actionManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    public Response enteringRequest(ServletContext context, HttpServletRequest httpRequest, HttpServletResponse httpResponse, String path) {
        if (!this.isJSONRequest(httpRequest)) {
            return null;
        }
        this.rawJson_.set(this.parseJSONRequest());
        return null;
    }

    public Action actionInvoking(Request request, Action action) {
        boolean onlyResonse = false;
        if (!this.isEnabled()) {
            if (action.getMethodInvoker().getMethod().isAnnotationPresent(JSONResponse.class)) {
                onlyResonse = true;
            } else {
                return action;
            }
        }
        return this.wrapAction(request.getCurrentDispatch().getPageComponent(), action, onlyResonse);
    }

    Action wrapAction(PageComponent pageComponent, Action action, boolean onlyResponse) {
        MethodInvoker methodInvoker = action.getMethodInvoker();
        Method method = methodInvoker.getMethod();
        Class<?>[] types = method.getParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        Object[] params = (Object[])methodInvoker.getParameters().clone();
        Gson gson = this.newGson();
        if (!onlyResponse) {
            for (int i = 0; i < annotations.length; ++i) {
                Object json;
                if (annotations[i].length != 0 || types[i].isPrimitive() || types[i] == String.class) continue;
                params[i] = json = gson.fromJson(this.rawJson_.get(), method.getParameterTypes()[i]);
                break;
            }
        }
        return this.actionManager_.newAction(action, (MethodInvoker)new ParametersReplacedMethodInvoker(methodInvoker, params, gson));
    }

    protected Gson newGson() {
        return new Gson();
    }

    public void leavingRequest(Request request) {
        if (!this.isEnabled()) {
            return;
        }
        this.rawJson_.set(null);
    }

    boolean isEnabled() {
        return this.rawJson_.get() != null;
    }

    protected String parseJSONRequest() {
        HttpServletRequest httpRequest = this.getHttpServletRequest();
        try {
            if (httpRequest.getCharacterEncoding() == null) {
                httpRequest.setCharacterEncoding("UTF-8");
            }
            return IOUtils.readString((Reader)httpRequest.getReader(), (boolean)false);
        }
        catch (IOException ex) {
            throw new IORuntimeException("Can't parse JSON request", (Throwable)ex);
        }
    }

    protected boolean isJSONRequest(HttpServletRequest httpRequest) {
        String contentType = httpRequest.getContentType();
        if (contentType == null) {
            return false;
        }
        int semi = contentType.indexOf(59);
        if (semi >= 0) {
            contentType = contentType.substring(0, semi).trim();
        }
        return CONTENT_TYPES.contains(contentType);
    }

    HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)this.applicationManager_.findContextApplication().getS2Container().getComponent(HttpServletRequest.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParametersReplacedMethodInvoker
    extends MethodInvokerWrapper {
        private Object[] params;
        private Gson gson;

        public ParametersReplacedMethodInvoker(MethodInvoker methodInvoker, Object[] params, Gson gson) {
            super(methodInvoker);
            this.params = params;
            this.gson = gson;
        }

        public Class<? extends Object> getReturnType() {
            return Response.class;
        }

        public Object[] getParameters() {
            return this.params;
        }

        public Object invoke(Object component, Object[] parameters) throws WrappingRuntimeException {
            Object returned = super.invoke(component, this.getParameters());
            if (returned == null || returned instanceof Response) {
                return returned;
            }
            return JSON.of(this.gson, returned, this.getMethodInvoker().getReturnType());
        }
    }
}

