/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.render.html;

import java.util.List;
import org.seasar.ymir.render.html.Option;
import org.seasar.ymir.render.html.Tag;
import org.seasar.ymir.util.HTMLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Optgroup
extends Tag {
    private static final long serialVersionUID = 1L;
    private static final String LS = System.getProperty("line.separator");
    private String label_;

    public Optgroup() {
    }

    public Optgroup(String label, List<Option> options) {
        this(label, options.toArray(new Option[0]));
    }

    public Optgroup(String label, Option[] options) {
        this.setLabel(label);
        this.setContent(options);
    }

    @Override
    protected void writeName(StringBuilder sb) {
        sb.append("optgroup");
    }

    @Override
    protected void writeAttributes(StringBuilder sb) {
        super.writeAttributes(sb);
        if (this.label_ != null) {
            sb.append(" label=\"").append(HTMLUtils.filter(this.label_)).append("\"");
        }
    }

    @Override
    protected void writeContent(StringBuilder sb) {
        Option[] options = (Option[])this.getContent();
        if (options != null && options.length > 0) {
            sb.append(">").append(LS);
            for (int i = 0; i < options.length; ++i) {
                sb.append("  ").append(options[i]).append(LS);
            }
            sb.append("</");
            this.writeName(sb);
        } else {
            sb.append(" /");
        }
    }

    public String getLabel() {
        return this.label_;
    }

    public Optgroup setLabel(String label) {
        this.label_ = label;
        return this;
    }

    public Option[] getOptions() {
        return (Option[])this.getContent();
    }
}

