/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.response;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.seasar.ymir.Response;
import org.seasar.ymir.ResponseHeader;
import org.seasar.ymir.ResponseType;

public abstract class ResponseBase
implements Response {
    private static final String PREFIX_CHARSET = "charset=";
    private int status_ = -1;
    private List<ResponseHeader> headerList_ = new ArrayList<ResponseHeader>();

    public void setType(ResponseType type) {
        throw new UnsupportedOperationException();
    }

    public void setSubordinate(boolean subordinate) {
        throw new UnsupportedOperationException();
    }

    public String getPath() {
        throw new UnsupportedOperationException();
    }

    public void setPath(String path) {
        throw new UnsupportedOperationException();
    }

    public InputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    public void setInputStream(InputStream is) {
        throw new UnsupportedOperationException();
    }

    public String getContentType() {
        return null;
    }

    public void setContentType(String contentType) {
        throw new UnsupportedOperationException();
    }

    public String getCharacterEncoding() {
        String sub;
        int semi;
        String contentType = this.getContentType();
        if (contentType != null && (semi = contentType.indexOf(59)) >= 0 && (sub = contentType.substring(semi + 1).trim()).toLowerCase().startsWith(PREFIX_CHARSET)) {
            return sub.substring(PREFIX_CHARSET.length()).trim();
        }
        return null;
    }

    public int getStatus() {
        return this.status_;
    }

    public void setStatus(int status) {
        this.status_ = status;
    }

    public void addDateHeader(String name, long value) {
        this.headerList_.add(new ResponseHeader(name, value, true));
    }

    public void addHeader(String name, String value) {
        this.headerList_.add(new ResponseHeader(name, value, true));
    }

    public void addIntHeader(String name, int value) {
        this.headerList_.add(new ResponseHeader(name, value, true));
    }

    public void setDateHeader(String name, long value) {
        this.headerList_.add(new ResponseHeader(name, value));
    }

    public void setHeader(String name, String value) {
        this.headerList_.add(new ResponseHeader(name, value));
    }

    public void setIntHeader(String name, int value) {
        this.headerList_.add(new ResponseHeader(name, value));
    }

    public ResponseHeader[] getResponseHeaders() {
        return this.headerList_.toArray(new ResponseHeader[0]);
    }

    public boolean containsHeader(String name) {
        for (ResponseHeader header : this.headerList_) {
            if (!name.equals(header.getName())) continue;
            return true;
        }
        return false;
    }
}

