/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.util;

import org.seasar.ymir.Action;
import org.seasar.ymir.Dispatch;
import org.seasar.ymir.Dispatcher;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.util.ResponseUtils;

public class RequestUtils {
    protected RequestUtils() {
    }

    public static boolean isProceeded(Request request) {
        if (request.getCurrentDispatch().getDispatcher() != Dispatcher.FORWARD) {
            return false;
        }
        return ResponseUtils.isProceed((Response)request.getAttribute("org.seasar.ymir..response"));
    }

    public static boolean isOriginalActionInvoked(Request request) {
        return RequestUtils.isOriginalActionInvoked(request.getCurrentDispatch());
    }

    public static boolean isOriginalActionInvoked(Dispatch dispatch) {
        Action originalAction = dispatch.getOriginalAction();
        Action action = dispatch.getAction();
        if (action == null || originalAction == null) {
            return false;
        }
        return RequestUtils.equals(originalAction, action);
    }

    static boolean equals(Action action1, Action action2) {
        if (action1.getTarget() != action2.getTarget()) {
            return false;
        }
        String name1 = action1.getName();
        String name2 = action2.getName();
        if (name1 == null) {
            return name2 == null;
        }
        return name1.equals(name2);
    }
}

