/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.servlet;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.ymir.Dispatcher;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.Ymir;
import org.seasar.ymir.servlet.MultipartServletRequest;
import org.seasar.ymir.util.ServletUtils;

public class YmirFilter
implements Filter {
    private Dispatcher dispatcher_;
    private ServletContext context_;
    private Ymir ymir_;

    public void init(FilterConfig config) throws ServletException {
        this.context_ = config.getServletContext();
        this.ymir_ = (Ymir)this.context_.getAttribute("org.seasar.ymir.ymir");
        String dispatcher = config.getInitParameter("dispatcher");
        if (dispatcher != null) {
            this.dispatcher_ = Dispatcher.valueOf(dispatcher.toUpperCase());
        }
    }

    public void destroy() {
        this.context_ = null;
        this.ymir_ = null;
        this.dispatcher_ = null;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpMethod method;
        HttpServletRequest httpRequest = (HttpServletRequest)req;
        HttpServletResponse httpResponse = (HttpServletResponse)res;
        try {
            method = HttpMethod.enumOf(httpRequest.getMethod());
        }
        catch (IllegalArgumentException ex) {
            throw new ServletException("Unknown HTTP method: " + httpRequest.getMethod());
        }
        Dispatcher dispatcher = this.getDispatcher((ServletRequest)httpRequest);
        Map fileParameterMap = null;
        if (dispatcher == Dispatcher.REQUEST && (fileParameterMap = (Map)httpRequest.getAttribute(MultipartServletRequest.ATTR_FORMFILEMAP)) != null) {
            httpRequest.removeAttribute(MultipartServletRequest.ATTR_FORMFILEMAP);
        }
        this.ymir_.process(this.context_, httpRequest, httpResponse, dispatcher, ServletUtils.getNativePath(httpRequest), method, fileParameterMap, chain);
    }

    protected Dispatcher getDispatcher(ServletRequest request) {
        if (this.dispatcher_ != null) {
            return this.dispatcher_;
        }
        return ServletUtils.getDispatcher(request);
    }
}

