/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.impl;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.cms.pluggable.ThreadContext;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.ymir.Action;
import org.seasar.ymir.ActionManager;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.ExceptionProcessor;
import org.seasar.ymir.IllegalClientCodeRuntimeException;
import org.seasar.ymir.PageComponent;
import org.seasar.ymir.PageComponentVisitor;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.ResponseType;
import org.seasar.ymir.Updater;
import org.seasar.ymir.Ymir;
import org.seasar.ymir.annotation.handler.AnnotationHandler;
import org.seasar.ymir.cache.CacheManager;
import org.seasar.ymir.handler.ExceptionHandler;
import org.seasar.ymir.impl.ExceptionHandlerActionMethodCondition;
import org.seasar.ymir.impl.ExceptionHandlerActionMethodHolder;
import org.seasar.ymir.interceptor.YmirProcessInterceptor;
import org.seasar.ymir.response.ForwardResponse;
import org.seasar.ymir.util.ClassUtils;
import org.seasar.ymir.util.ResponseUtils;
import org.seasar.ymir.util.ThrowableUtils;
import org.seasar.ymir.util.YmirUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionProcessorImpl
implements ExceptionProcessor {
    private static final String METHODNAME_HANDLE = "handle";
    private Ymir ymir_;
    private ActionManager actionManager_;
    private AnnotationHandler annotationHandler_;
    private ApplicationManager applicationManager_;
    private Updater[] updaters_ = new Updater[0];
    private YmirProcessInterceptor[] ymirProcessInterceptors_ = new YmirProcessInterceptor[0];
    private Map<Class<?>, ExceptionHandlerActionMethodHolder> actionMethodHolderMap_;
    private final Log log_ = LogFactory.getLog(ExceptionProcessorImpl.class);

    @Binding(bindingType=BindingType.MUST)
    public void setYmir(Ymir ymir) {
        this.ymir_ = ymir;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setActionManager(ActionManager actionManager) {
        this.actionManager_ = actionManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setAnnotationHandler(AnnotationHandler annotationHandler) {
        this.annotationHandler_ = annotationHandler;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setCacheManager(CacheManager cacheManager) {
        this.actionMethodHolderMap_ = cacheManager.newMap();
    }

    public void setUpdaters(Updater[] updaters) {
        this.updaters_ = updaters;
    }

    @Binding(value="@org.seasar.ymir.util.ContainerUtils@findAllComponents(container, @org.seasar.ymir.interceptor.YmirProcessInterceptor@class)", bindingType=BindingType.MUST)
    public void setYmirProcessInterceptors(YmirProcessInterceptor[] ymirProcessInterceptors) {
        this.ymirProcessInterceptors_ = ymirProcessInterceptors;
        YmirUtils.sortYmirProcessInterceptors(this.ymirProcessInterceptors_);
    }

    @Override
    public Response process(Request request, Throwable target, boolean useHandlerInPage) {
        Response response;
        boolean global;
        Object handler;
        Class<?> exceptionClass;
        block19: {
            PageComponent pageComponent;
            Response response2;
            int i;
            if (this.log_.isDebugEnabled()) {
                this.log_.debug((Object)"Exception has occured", target);
            }
            request.removeAttribute("handler");
            request.removeAttribute("handler.global");
            request.removeAttribute("exception");
            target = ThrowableUtils.unwrap(target);
            for (i = 0; i < this.ymirProcessInterceptors_.length; ++i) {
                response2 = this.ymirProcessInterceptors_[i].exceptionProcessingStarted(request, target);
                if (response2 == null) continue;
                if (this.log_.isDebugEnabled()) {
                    this.log_.debug((Object)("Response has been created by: " + this.ymirProcessInterceptors_[i] + ": " + response2));
                }
                return response2;
            }
            if (this.ymir_.isUnderDevelopment() && YmirUtils.isUpdatable(request)) {
                for (i = 0; i < this.updaters_.length; ++i) {
                    response2 = this.updaters_[i].updateByException(request, target);
                    if (response2 == null) continue;
                    if (this.log_.isDebugEnabled()) {
                        this.log_.debug((Object)("Response has been created by: " + this.updaters_[i] + ": " + response2));
                    }
                    return response2;
                }
            }
            exceptionClass = null;
            handler = null;
            global = false;
            response = null;
            if (useHandlerInPage && (pageComponent = request.getCurrentDispatch().getPageComponent()) != null) {
                VisitorForProcessingExceptionHandler visitor = new VisitorForProcessingExceptionHandler(request, target, request.getActionName());
                try {
                    exceptionClass = target.getClass();
                    do {
                        visitor.setExceptionClass(exceptionClass);
                        response = (Response)pageComponent.accept(visitor, new Object[0]);
                        if (response == null) continue;
                        handler = visitor.getHandler();
                        break;
                    } while ((exceptionClass = exceptionClass.getSuperclass()) != Object.class);
                }
                catch (Throwable t) {
                    target = ThrowableUtils.unwrap(t);
                    if (!this.log_.isDebugEnabled()) break block19;
                    this.log_.debug((Object)"In-page exception handler re-throwed exception", target);
                }
            }
        }
        if (response == null) {
            global = true;
            S2Container container = this.getS2Container();
            ComponentDef handlerCd = null;
            exceptionClass = target.getClass();
            do {
                String componentName;
                if (container.hasComponentDef((Object)(componentName = this.getComponentName(exceptionClass)))) {
                    handlerCd = container.getComponentDef((Object)componentName);
                    break;
                }
                componentName = "default_" + this.getComponentName(exceptionClass);
                if (!container.hasComponentDef((Object)componentName)) continue;
                handlerCd = container.getComponentDef((Object)componentName);
                break;
            } while ((exceptionClass = exceptionClass.getSuperclass()) != Object.class);
            handler = handlerCd.getComponent();
            Class handlerClass = handlerCd.getComponentClass();
            Method actionMethod = this.findActionMethod(handlerClass, true, exceptionClass, null, true);
            if (actionMethod == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("Exception handler class must have a method annotated by @ExceptionHandler");
                if (this.isExceptionHandlerInterfaceEnabled()) {
                    sb.append(", or must implements ExceptionHandler interface with valid concrete parameter type");
                }
                sb.append(": ").append(handlerClass.getName());
                throw new IllegalClientCodeRuntimeException(sb.toString());
            }
            response = this.process(request, handler, true, handlerClass, actionMethod, exceptionClass, target);
        }
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("Raw response (1): " + response));
        }
        if (this.isExceptionHandlerInterfaceEnabled() && handler instanceof ExceptionHandler && response.getType() == ResponseType.PASSTHROUGH) {
            response = new ForwardResponse(ResponseUtils.getExceptionTemplatePath(exceptionClass));
        }
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("Raw response (2): " + response));
        }
        request.setAttribute("handler", handler);
        request.setAttribute("handler.global", global);
        request.setAttribute("exception", target);
        ThreadContext context = this.getThreadContext();
        context.setComponent(Response.class, (Object)response);
        for (int i = 0; i < this.ymirProcessInterceptors_.length; ++i) {
            response = this.ymirProcessInterceptors_[i].responseCreatedByExceptionHandler(request, response, handler, global);
            context.setComponent(Response.class, (Object)response);
        }
        return response;
    }

    Response process(Request request, Object handler, boolean global, Class<?> handlerClass, Method actionMethod, Class<?> exceptionClass, Throwable target) {
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("Process exception handling. ExceptionHandler: " + handler));
        }
        Action action = this.newAction(handler, handlerClass, actionMethod, target);
        for (int i = 0; i < this.ymirProcessInterceptors_.length; ++i) {
            action = this.ymirProcessInterceptors_[i].exceptionHandlerActionInvoking(request, action, global);
        }
        return this.actionManager_.invokeAction(action);
    }

    Method findActionMethod(Class<?> handlerClass, boolean global, Class<?> exceptionClass, String actionName, boolean checkInterface) {
        Method[] methods;
        Method method = this.getActionMethodHolder(handlerClass, global).getMethod(new ExceptionHandlerActionMethodCondition(exceptionClass, actionName));
        if (method == null && checkInterface && this.isExceptionHandlerInterfaceEnabled() && ExceptionHandler.class.isAssignableFrom(handlerClass) && (methods = ClassUtils.getMethods(handlerClass, METHODNAME_HANDLE)).length > 0) {
            method = methods[0];
        }
        return method;
    }

    ExceptionHandlerActionMethodHolder getActionMethodHolder(Class<?> handlerClass, boolean global) {
        ExceptionHandlerActionMethodHolder methodHolder = this.actionMethodHolderMap_.get(handlerClass);
        if (methodHolder == null) {
            methodHolder = new ExceptionHandlerActionMethodHolder(handlerClass, global, this.actionManager_, this.annotationHandler_);
            this.actionMethodHolderMap_.put(handlerClass, methodHolder);
        }
        return methodHolder;
    }

    Action newAction(Object handler, Class<?> handlerClass, Method method, Throwable targetThrowable) {
        return this.actionManager_.newAction(handler, handlerClass, method, targetThrowable);
    }

    String getComponentName(Class<?> clazz) {
        return Introspector.decapitalize(ClassUtils.getShortName(clazz)) + "Handler";
    }

    S2Container getS2Container() {
        return this.ymir_.getApplication().getS2Container();
    }

    boolean isExceptionHandlerInterfaceEnabled() {
        return PropertyUtils.valueOf((String)this.applicationManager_.findContextApplication().getProperty("core.handler.exceptionHandlerInterface.enable"), (boolean)true);
    }

    ThreadContext getThreadContext() {
        return (ThreadContext)this.ymir_.getApplication().getS2Container().getRoot().getComponent(ThreadContext.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VisitorForProcessingExceptionHandler
    extends PageComponentVisitor<Response> {
        private Request request_;
        private Class<?> exceptionClass_;
        private Throwable target_;
        private String actionName_;
        private Object handler_;
        private Class<?> handlerClass_;

        protected VisitorForProcessingExceptionHandler(Request request, Throwable target, String actionName) {
            this.request_ = request;
            this.target_ = target;
            this.actionName_ = actionName;
        }

        public void setExceptionClass(Class<?> exceptionClass) {
            this.exceptionClass_ = exceptionClass;
        }

        @Override
        public Response process(PageComponent pageComponent, Object ... parameters) {
            this.handlerClass_ = pageComponent.getPageClass();
            Method actionMethod = ExceptionProcessorImpl.this.findActionMethod(this.handlerClass_, false, this.exceptionClass_, this.actionName_, false);
            if (actionMethod != null) {
                if (ExceptionProcessorImpl.this.log_.isDebugEnabled()) {
                    ExceptionProcessorImpl.this.log_.debug((Object)("Exception handler " + ClassUtils.getPrettyName(actionMethod.getDeclaringClass()) + "#" + actionMethod.getName() + "() is handling the exception"));
                }
                this.handler_ = pageComponent.getPage();
                return ExceptionProcessorImpl.this.process(this.request_, this.handler_, false, this.handlerClass_, actionMethod, this.exceptionClass_, this.target_);
            }
            return null;
        }

        public Object getHandler() {
            return this.handler_;
        }

        public Class<?> getHandlerClass() {
            return this.handlerClass_;
        }
    }
}

