/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.impl;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.ymir.ActionManager;
import org.seasar.ymir.IllegalClientCodeRuntimeException;
import org.seasar.ymir.MethodHolder;
import org.seasar.ymir.annotation.handler.AnnotationHandler;
import org.seasar.ymir.handler.annotation.ExceptionHandler;
import org.seasar.ymir.impl.ExceptionHandlerActionMethodCondition;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExceptionHandlerActionMethodHolder
implements MethodHolder<ExceptionHandlerActionMethodCondition> {
    private ActionManager actionManager_;
    private AnnotationHandler annotationHandler_;
    private Map<Class<?>, Entry[]> entriesMap_ = new HashMap();

    public ExceptionHandlerActionMethodHolder(Class<?> handlerClass, boolean global, ActionManager actionManager, AnnotationHandler annotationHandler) {
        this.actionManager_ = actionManager;
        this.annotationHandler_ = annotationHandler;
        for (Method method : ClassUtils.getMethods(handlerClass)) {
            ExceptionHandler annotation = this.annotationHandler_.getAnnotation(method, ExceptionHandler.class);
            if (annotation == null) continue;
            if (global && annotation.actionName().length > 0) {
                throw new IllegalClientCodeRuntimeException("Can't specify 'actionName' element of @ExceptionHandler for a global handler: method=" + method);
            }
            Class<Throwable> exceptionClass = annotation.value();
            if (global) {
                if (exceptionClass != Throwable.class) {
                    throw new IllegalClientCodeRuntimeException("Can't specify 'value' element of @ExceptionHandler for a global handler: method=" + method);
                }
            } else if (exceptionClass == Throwable.class) {
                for (Class<?> type : method.getParameterTypes()) {
                    if (!Throwable.class.isAssignableFrom(type)) continue;
                    exceptionClass = type;
                    break;
                }
            }
            Entry entry = new Entry(method, annotation);
            Object[] entries = this.entriesMap_.get(exceptionClass);
            if (entries == null) {
                entries = new Entry[]{entry};
            } else {
                if (entry.getAnnotation().actionName().length == 0 && ((Entry)entries[entries.length - 1]).getAnnotation().actionName().length == 0) {
                    throw new IllegalClientCodeRuntimeException("Duplicate @ExceptionHandler for " + exceptionClass + " found in a handler class '" + ClassUtils.getPrettyName(handlerClass) + "'");
                }
                entries = (Entry[])ArrayUtil.add((Object[])entries, (Object)entry);
                Arrays.sort(entries);
            }
            this.entriesMap_.put(exceptionClass, (Entry[])entries);
        }
    }

    @Override
    public Method getMethod(ExceptionHandlerActionMethodCondition condition) {
        Entry[] entries = null;
        Class<?> clazz = condition.getExceptionClass();
        String actionName = condition.getActionName();
        while ((entries = this.entriesMap_.get(clazz)) == null && (clazz = clazz.getSuperclass()) != Object.class) {
        }
        if (entries != null) {
            for (Entry entry : entries) {
                if (!this.actionManager_.isMatched(actionName, entry.getAnnotation().actionName())) continue;
                return entry.getMethod();
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry
    implements Comparable<Entry> {
        private Method method_;
        private ExceptionHandler annotation_;

        Entry(Method method, ExceptionHandler annotation) {
            this.method_ = method;
            this.annotation_ = annotation;
        }

        public Method getMethod() {
            return this.method_;
        }

        public ExceptionHandler getAnnotation() {
            return this.annotation_;
        }

        @Override
        public int compareTo(Entry o) {
            String[] a1 = this.getAnnotation().actionName();
            String[] a2 = o.getAnnotation().actionName();
            int cmp = a2.length - a1.length;
            if (cmp == 0) {
                for (int i = 0; i < a1.length && cmp == 0; ++i) {
                    cmp = a1[i].compareTo(a2[i]);
                }
            }
            return cmp;
        }
    }
}

