/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.converter.impl;

import java.lang.annotation.Annotation;
import org.seasar.ymir.converter.TypeConversionException;
import org.seasar.ymir.converter.impl.TypeConverterBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleConverter
extends TypeConverterBase<Double> {
    public DoubleConverter() {
        this.type_ = Double.class;
    }

    @Override
    protected Double doConvert(Object value, Annotation[] hint) throws TypeConversionException {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Boolean) {
            return (byte)((Boolean)value != false ? 1 : 0);
        }
        try {
            String valueString = value.toString();
            if ("2.2250738585072012e-308".equals(valueString)) {
                return 2.22507385850721E-308;
            }
            return Double.valueOf(valueString);
        }
        catch (Exception ex) {
            throw new TypeConversionException(ex, value, this.getType());
        }
    }
}

