/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.conversation.impl;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.IllegalClientCodeRuntimeException;
import org.seasar.ymir.YmirContext;
import org.seasar.ymir.conversation.BeginCondition;
import org.seasar.ymir.conversation.Conversation;
import org.seasar.ymir.conversation.Conversations;
import org.seasar.ymir.conversation.IllegalTransitionRuntimeException;
import org.seasar.ymir.conversation.impl.ConversationImpl;
import org.seasar.ymir.hotdeploy.HotdeployManager;
import org.seasar.ymir.util.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversationsImpl
implements Conversations {
    private static final long serialVersionUID = 378981595198068349L;
    private transient HotdeployManager hotdeployManager_;
    private transient ApplicationManager applicationManager_;
    private LinkedList<Conversation> conversationStack_ = new LinkedList();
    private Conversation currentConversation_;

    public void setHotdeployManager(HotdeployManager hotdeployManager) {
        this.hotdeployManager_ = hotdeployManager;
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append("{").append(LogUtils.LS);
        sb.append("  ").append("current=").append(LogUtils.addIndent(this.currentConversation_, "  ")).append(LogUtils.LS);
        if (!this.conversationStack_.isEmpty()) {
            sb.append("  ").append("stack=").append(LogUtils.addIndent(this.conversationStack_, "  ")).append(LogUtils.LS);
        }
        sb.append("}");
        return sb.toString();
    }

    private Object readResolve() throws ObjectStreamException {
        this.hotdeployManager_ = (HotdeployManager)YmirContext.getYmir().getApplication().getS2Container().getComponent(HotdeployManager.class);
        this.applicationManager_ = (ApplicationManager)YmirContext.getYmir().getApplication().getS2Container().getComponent(ApplicationManager.class);
        return this;
    }

    @Override
    public synchronized Conversation getCurrentConversation() {
        return this.currentConversation_;
    }

    @Override
    public synchronized String getCurrentConversationName() {
        if (this.currentConversation_ == null) {
            return null;
        }
        return this.currentConversation_.getName();
    }

    @Override
    public synchronized Conversation getSuperConversation() {
        if (this.conversationStack_.size() > 0) {
            return this.conversationStack_.getFirst();
        }
        return null;
    }

    @Override
    public synchronized String getSuperConversationName() {
        Conversation superConversation = this.getSuperConversation();
        if (superConversation == null) {
            return null;
        }
        return superConversation.getName();
    }

    protected Conversation newConversation(String conversationName) {
        ConversationImpl impl = new ConversationImpl(conversationName);
        impl.setHotdeployManager(this.hotdeployManager_);
        impl.setApplicationManager(this.applicationManager_);
        return impl;
    }

    @Override
    public synchronized Object getAttribute(String name) {
        Object value = this.getRawAttribute(name);
        if (value != null && YmirContext.isUnderDevelopment()) {
            value = this.hotdeployManager_.fit(value);
        }
        return value;
    }

    @Override
    public synchronized Object getRawAttribute(String name) {
        if (this.currentConversation_ != null) {
            return this.currentConversation_.getAttribute(name);
        }
        return null;
    }

    @Override
    public synchronized void setAttribute(String name, Object value) {
        if (this.currentConversation_ != null) {
            this.currentConversation_.setAttribute(name, value);
        }
    }

    @Override
    public synchronized void begin(String conversationName, String phase, BeginCondition condition) {
        if (this.equals(this.getCurrentConversationName(), conversationName)) {
            if (condition == BeginCondition.EXCEPT_FOR_SAME_CONVERSATION) {
                return;
            }
            if (this.equals(this.currentConversation_.getPhase(), phase) && condition == BeginCondition.EXCEPT_FOR_SAME_CONVERSATION_AND_SAME_PHASE) {
                return;
            }
        } else if (this.currentConversation_ != null) {
            Iterator itr = this.conversationStack_.iterator();
            while (itr.hasNext()) {
                Conversation conversation = (Conversation)itr.next();
                itr.remove();
                if (!conversation.getName().equals(conversationName)) continue;
                break;
            }
        }
        this.currentConversation_ = this.newConversation(conversationName);
        this.currentConversation_.setPhase(phase);
    }

    boolean equals(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    @Override
    public synchronized Object end() {
        this.removeCurrentConversation();
        if (this.conversationStack_.size() > 0) {
            this.currentConversation_ = this.conversationStack_.removeFirst();
            return this.currentConversation_.getReenterResponse();
        }
        return null;
    }

    @Override
    public synchronized boolean isInSubConversation() {
        return this.conversationStack_.size() > 0 && this.conversationStack_.peek().getReenterResponse() != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public synchronized void join(String conversationName, String phase, String[] followAfter, boolean acceptBrowsersBackButton) {
        String currentPhase;
        if (this.currentConversation_ == null) {
            this.illegalTransitionDetected();
            return;
        }
        if (!this.currentConversation_.getName().equals(conversationName)) {
            Conversation conversation;
            if (!acceptBrowsersBackButton) {
                this.illegalTransitionDetected();
                return;
            }
            int idx = 0;
            Iterator itr = this.conversationStack_.iterator();
            while (itr.hasNext() && !(conversation = (Conversation)itr.next()).getName().equals(conversationName)) {
                ++idx;
            }
            if (idx >= this.conversationStack_.size()) {
                this.illegalTransitionDetected();
                return;
            }
            for (int i = 0; i < idx; ++i) {
                this.conversationStack_.removeFirst();
            }
            this.end();
        }
        if (this.equals(currentPhase = this.currentConversation_.getPhase(), phase)) {
            return;
        }
        if (!acceptBrowsersBackButton) {
            boolean matched = false;
            for (int i = 0; i < followAfter.length; ++i) {
                if (!followAfter[i].equals(currentPhase)) continue;
                matched = true;
                break;
            }
            if (!matched) {
                this.illegalTransitionDetected();
                return;
            }
        }
        this.currentConversation_.setPhase(phase);
    }

    protected void illegalTransitionDetected() {
        throw new IllegalTransitionRuntimeException();
    }

    void removeCurrentConversation() {
        if (this.currentConversation_ != null) {
            this.currentConversation_ = null;
        }
    }

    void clear() {
        this.currentConversation_ = null;
        this.conversationStack_.clear();
    }

    @Override
    public synchronized void beginSubConversation(Object reenterResponse) {
        if (this.currentConversation_ == null) {
            throw new IllegalClientCodeRuntimeException("Conversation is not begun");
        }
        this.currentConversation_.setReenterResponse(reenterResponse);
        this.conversationStack_.addFirst(this.currentConversation_);
        this.currentConversation_ = null;
    }

    LinkedList<Conversation> getConversationStack() {
        return this.conversationStack_;
    }

    @Override
    public Iterator<String> getAttributeNames() {
        if (this.currentConversation_ != null) {
            return this.currentConversation_.getAttributeNames();
        }
        return new ArrayList().iterator();
    }
}

