/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.conversation.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.Request;
import org.seasar.ymir.annotation.handler.AnnotationHandler;
import org.seasar.ymir.conversation.Conversation;
import org.seasar.ymir.conversation.ConversationManager;
import org.seasar.ymir.conversation.Conversations;
import org.seasar.ymir.scope.Scope;
import org.seasar.ymir.session.SessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversationScope
implements Scope {
    public static final String ATTRPREFIX_CONVERSATION = "org.seasar.ymir.conversation.";
    public static final String ATTR_CONVERSATIONS = "org.seasar.ymir.conversation.conversations";
    private ApplicationManager applicationManager_;
    private AnnotationHandler annotationHandler_;
    private SessionManager sessionManager_;
    private ConversationManager conversationManager_;

    @Binding(bindingType=BindingType.MUST)
    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setAnnotationHandler(AnnotationHandler annotationHandler) {
        this.annotationHandler_ = annotationHandler;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager_ = sessionManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setConversationManager(ConversationManager conversationManager) {
        this.conversationManager_ = conversationManager;
    }

    @Override
    public Object getAttribute(String name, Class<?> type) {
        if (name == null) {
            return null;
        }
        if (this.isUseSessionScopeAsConversationScope()) {
            return this.sessionManager_.getRawAttribute(name);
        }
        Conversation conversation = this.findCurrentConversation();
        if (conversation != null) {
            return conversation.getAttribute(name);
        }
        return null;
    }

    Conversation findCurrentConversation() {
        Conversations conversations = this.conversationManager_.getConversations();
        if (conversations == null) {
            return null;
        }
        String pageConversationName = this.getPageConversationName();
        if (pageConversationName == null) {
            return null;
        }
        Conversation conversation = conversations.getCurrentConversation();
        if (conversation == null) {
            conversation = conversations.getSuperConversation();
        }
        if (conversation == null) {
            return null;
        }
        if (!pageConversationName.equals(conversation.getName())) {
            return null;
        }
        return conversation;
    }

    String getPageConversationName() {
        org.seasar.ymir.conversation.annotation.Conversation conversation = this.annotationHandler_.getAnnotation(((Request)this.getS2Container().getComponent(Request.class)).getCurrentDispatch().getPageComponent().getPageClass(), org.seasar.ymir.conversation.annotation.Conversation.class);
        if (conversation != null) {
            return conversation.name();
        }
        return null;
    }

    S2Container getS2Container() {
        return this.applicationManager_.findContextApplication().getS2Container();
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (name == null) {
            return;
        }
        if (this.isUseSessionScopeAsConversationScope()) {
            this.sessionManager_.setAttribute(name, value);
        } else {
            Conversation conversation = this.findCurrentConversation();
            if (conversation != null) {
                conversation.setAttribute(name, value);
            }
        }
    }

    boolean isUseSessionScopeAsConversationScope() {
        return PropertyUtils.valueOf((String)this.applicationManager_.findContextApplication().getProperty("core.conversation.useSessionScopeAsConversationScope"), (boolean)false);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        if (this.isUseSessionScopeAsConversationScope()) {
            return new ArrayList().iterator();
        }
        Conversation conversation = this.findCurrentConversation();
        if (conversation != null) {
            return conversation.getAttributeNames();
        }
        return new ArrayList().iterator();
    }
}

