/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.constraint;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.ymir.Action;
import org.seasar.ymir.ActionManager;
import org.seasar.ymir.Application;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.IllegalClientCodeRuntimeException;
import org.seasar.ymir.MethodInvoker;
import org.seasar.ymir.PageComponent;
import org.seasar.ymir.PageComponentVisitor;
import org.seasar.ymir.Request;
import org.seasar.ymir.WrappingRuntimeException;
import org.seasar.ymir.annotation.handler.AnnotationHandler;
import org.seasar.ymir.cache.CacheManager;
import org.seasar.ymir.constraint.ConstraintBag;
import org.seasar.ymir.constraint.ConstraintBundle;
import org.seasar.ymir.constraint.ConstraintManager;
import org.seasar.ymir.constraint.ConstraintType;
import org.seasar.ymir.constraint.CrosscuttingConstraint;
import org.seasar.ymir.constraint.PermissionDeniedException;
import org.seasar.ymir.constraint.ValidationFailedException;
import org.seasar.ymir.constraint.annotation.SuppressConstraints;
import org.seasar.ymir.interceptor.impl.AbstractYmirProcessInterceptor;
import org.seasar.ymir.message.Notes;
import org.seasar.ymir.util.ClassUtils;
import org.seasar.ymir.util.ContainerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintInterceptor
extends AbstractYmirProcessInterceptor {
    public static final String ACTION_VALIDATIONFAILED = "_validationFailed";
    public static final String ACTION_PERMISSIONDENIED = "_permissionDenied";
    static final Set<ConstraintType> EMPTY_SUPPRESSTYPESET = EnumSet.noneOf(ConstraintType.class);
    private ActionManager actionManager_;
    private AnnotationHandler annotationHandler_;
    private ApplicationManager applicationManager_;
    private ConstraintManager constraintManager_;
    private Map<Method, Set<ConstraintType>> suppressTypeSetMap_;
    private PageComponentVisitor<Action> visitorForFindingPermissionDeniedMethod_ = new VisitorForFindingPermissionDeniedMethod();
    private PageComponentVisitor<Action> visitorForFindingValidationFailedMethod_ = new VisitorForFindingValidationFailedMethod();

    @Binding(bindingType=BindingType.MUST)
    public void setActionManager(ActionManager actionManager) {
        this.actionManager_ = actionManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setAnnotationHandler(AnnotationHandler annotationHandler) {
        this.annotationHandler_ = annotationHandler;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setCacheManager(CacheManager cacheManager) {
        this.suppressTypeSetMap_ = cacheManager.newMap();
    }

    @Binding(bindingType=BindingType.MUST)
    public void setConstraintManager(ConstraintManager constraintManager) {
        this.constraintManager_ = constraintManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Action actionInvoking(Request request, Action action) {
        PageComponent pageComponent = request.getCurrentDispatch().getPageComponent();
        Action finalAction = null;
        try {
            Notes notes = this.confirmConstraint(pageComponent, request);
            if (notes == null) return action;
            request.setAttribute("notes", notes);
            if (!this.isValidationFailedMethodEnabled()) throw new WrappingRuntimeException(new ValidationFailedException(notes));
            finalAction = (Action)pageComponent.accept(this.visitorForFindingValidationFailedMethod_, notes);
            if (finalAction != null) return finalAction;
            return this.actionManager_.newVoidAction(pageComponent.getPage());
        }
        catch (PermissionDeniedException ex) {
            if (!this.isPermissionDeniedMethodEnabled()) throw new WrappingRuntimeException(ex);
            finalAction = (Action)pageComponent.accept(this.visitorForFindingPermissionDeniedMethod_, ex);
            if (finalAction != null) return finalAction;
            throw new WrappingRuntimeException(ex);
        }
    }

    boolean isValidationFailedMethodEnabled() {
        return PropertyUtils.valueOf((String)this.applicationManager_.findContextApplication().getProperty("core.constraint.validationFailedMethod.enable"), (boolean)true);
    }

    boolean isPermissionDeniedMethodEnabled() {
        return PropertyUtils.valueOf((String)this.applicationManager_.findContextApplication().getProperty("core.constraint.permissionDeniedMethod.enable"), (boolean)true);
    }

    Notes confirmConstraint(PageComponent pageComponent, Request request) throws PermissionDeniedException {
        Action action = request.getCurrentDispatch().getAction();
        MethodInvoker actionInvoker = null;
        Method actionMethod = null;
        if (action != null && (actionInvoker = action.getMethodInvoker()) != null) {
            actionMethod = actionInvoker.getMethod();
        }
        Set<ConstraintType> suppressTypeSet = this.getSuppressTypeSet(actionMethod);
        Notes notes = new Notes();
        this.constraintManager_.confirmConstraint(this.getConstraintBagsFromBundlesAndTheOthers(), suppressTypeSet, pageComponent.getPage(), request, notes);
        this.constraintManager_.confirmConstraint(this.constraintManager_.getConstraintBags(actionMethod, this.constraintManager_.getAlwaysDecider()), suppressTypeSet, pageComponent.getPage(), request, notes);
        try {
            VisitorForConfirmingConstraint visitor = new VisitorForConfirmingConstraint(request, suppressTypeSet, notes);
            pageComponent.accept(visitor, new Object[0]);
            return visitor.getNotes();
        }
        catch (WrappingRuntimeException ex) {
            if (ex.getCause() instanceof PermissionDeniedException) {
                throw (PermissionDeniedException)ex.getCause();
            }
            throw ex;
        }
    }

    Set<ConstraintType> getSuppressTypeSet(Method actionMethod) {
        if (actionMethod == null) {
            return EnumSet.noneOf(ConstraintType.class);
        }
        Set<ConstraintType> suppressTypeSet = this.suppressTypeSetMap_.get(actionMethod);
        if (suppressTypeSet == null) {
            suppressTypeSet = EnumSet.noneOf(ConstraintType.class);
            ConstraintType[] types = this.getSuppressConstraintsValue(actionMethod);
            if (types != null) {
                for (int i = 0; i < types.length; ++i) {
                    suppressTypeSet.add(types[i]);
                }
            }
            this.suppressTypeSetMap_.put(actionMethod, suppressTypeSet);
        }
        return suppressTypeSet;
    }

    private ConstraintType[] getSuppressConstraintsValue(Method actionMethod) {
        SuppressConstraints suppress = this.annotationHandler_.getAnnotation(actionMethod, SuppressConstraints.class);
        if (suppress != null) {
            return suppress.value();
        }
        return null;
    }

    ConstraintBag<?>[] getConstraintBagsFromBundlesAndTheOthers() {
        Application application = this.applicationManager_.findContextApplication();
        ConstraintBag[] bags = application.getRelatedObject(ConstraintBag[].class);
        if (bags == null) {
            ArrayList list = new ArrayList();
            ComponentDef[] bundleCds = ContainerUtils.findAllComponentDefs((S2Container)application.getS2Container(), ConstraintBundle.class);
            for (int i = 0; i < bundleCds.length; ++i) {
                this.constraintManager_.getConstraintBags((AnnotatedElement)bundleCds[i].getComponentClass(), (ConstraintBundle)bundleCds[i].getComponent(), list);
            }
            ComponentDef[] constraintCds = ContainerUtils.findAllComponentDefs((S2Container)application.getS2Container(), CrosscuttingConstraint.class);
            for (int i = 0; i < constraintCds.length; ++i) {
                this.constraintManager_.getConstraintBags((AnnotatedElement)constraintCds[i].getComponentClass(), (CrosscuttingConstraint)constraintCds[i].getComponent(), list);
            }
            bags = list.toArray(ConstraintManager.CONSTRAINTBAGS_EMPTY);
            application.setRelatedObject(ConstraintBag[].class, bags);
        }
        return bags;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VisitorForConfirmingConstraint
    extends PageComponentVisitor<Object> {
        private Request request_;
        private Set<ConstraintType> suppressTypeSet_;
        private Notes notes_;

        public VisitorForConfirmingConstraint(Request request, Set<ConstraintType> suppressTypeSet, Notes notes) {
            this.request_ = request;
            this.suppressTypeSet_ = suppressTypeSet;
            this.notes_ = notes;
        }

        @Override
        public Object process(PageComponent pageComponent, Object ... parameters) {
            Object page = pageComponent.getPage();
            try {
                ConstraintInterceptor.this.constraintManager_.confirmConstraint(pageComponent.getPageClass(), this.suppressTypeSet_, page, this.request_, this.notes_);
            }
            catch (PermissionDeniedException ex) {
                throw new WrappingRuntimeException(ex);
            }
            return null;
        }

        public Notes getNotes() {
            if (!this.notes_.isEmpty()) {
                return this.notes_;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VisitorForFindingPermissionDeniedMethod
    extends PageComponentVisitor<Action> {
        protected VisitorForFindingPermissionDeniedMethod() {
        }

        @Override
        public Action process(PageComponent pageComponent, Object ... parameters) {
            Object page = pageComponent.getPage();
            Class<?> pageClass = pageComponent.getPageClass();
            Method[] methods = ClassUtils.getMethods(pageClass, ConstraintInterceptor.ACTION_PERMISSIONDENIED);
            if (methods.length == 1) {
                return ConstraintInterceptor.this.actionManager_.newAction(page, pageClass, methods[0], parameters[0]);
            }
            if (methods.length == 0) {
                return null;
            }
            throw new IllegalClientCodeRuntimeException("Method '_permissionDenied' must be single: class=" + pageClass + ", method=" + Arrays.asList(methods));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VisitorForFindingValidationFailedMethod
    extends PageComponentVisitor<Action> {
        protected VisitorForFindingValidationFailedMethod() {
        }

        @Override
        public Action process(PageComponent pageComponent, Object ... parameters) {
            Object page = pageComponent.getPage();
            Class<?> pageClass = pageComponent.getPageClass();
            Method[] methods = ClassUtils.getMethods(pageClass, ConstraintInterceptor.ACTION_VALIDATIONFAILED);
            if (methods.length == 1) {
                return ConstraintInterceptor.this.actionManager_.newAction(page, pageClass, methods[0], parameters[0]);
            }
            if (methods.length == 0) {
                return null;
            }
            throw new IllegalClientCodeRuntimeException("Method '_validationFailed' must be single: class=" + pageClass + ", method=" + Arrays.asList(methods));
        }
    }
}

