/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.ymir.ActionManager;
import org.seasar.ymir.ComponentMetaData;
import org.seasar.ymir.Phase;
import org.seasar.ymir.annotation.Invoke;
import org.seasar.ymir.annotation.handler.AnnotationHandler;
import org.seasar.ymir.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentMetaDataImpl
implements ComponentMetaData {
    private static final Method[] EMPTY_METHODS = new Method[0];
    private ActionManager actionManager_;
    private AnnotationHandler annotationHandler_;
    private Map<Phase, MethodData[]> methodDatasMap_ = new HashMap<Phase, MethodData[]>();

    public ComponentMetaDataImpl(Class<?> clazz, ActionManager actionManager, AnnotationHandler annotationHandler) {
        this.actionManager_ = actionManager;
        this.annotationHandler_ = annotationHandler;
        Method[] methods = ClassUtils.getMethods(clazz);
        for (int i = 0; i < methods.length; ++i) {
            this.register(methods[i]);
        }
    }

    void register(Method method) {
        Invoke invoke = this.annotationHandler_.getAnnotation(method, Invoke.class);
        if (invoke != null) {
            Phase phase = invoke.value();
            String[] actionNamePatterns = invoke.actionName();
            Object[] methodDatas = this.methodDatasMap_.get((Object)phase);
            MethodData methodData = new MethodData(method, actionNamePatterns);
            methodDatas = methodDatas == null ? new MethodData[]{methodData} : (MethodData[])ArrayUtil.add((Object[])methodDatas, (Object)methodData);
            this.methodDatasMap_.put(phase, (MethodData[])methodDatas);
        }
    }

    @Override
    public Method[] getMethods(Phase phase, String actionName) {
        MethodData[] methodDatas = this.methodDatasMap_.get((Object)phase);
        if (methodDatas == null) {
            return EMPTY_METHODS;
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        for (MethodData methodData : methodDatas) {
            if (!methodData.isMatched(actionName)) continue;
            methods.add(methodData.getMethod());
        }
        return methods.toArray(EMPTY_METHODS);
    }

    class MethodData {
        private Method method_;
        private String[] actionNamePatterns_;

        public MethodData(Method method, String[] actionNamePatterns) {
            this.method_ = method;
            this.actionNamePatterns_ = actionNamePatterns;
        }

        public Method getMethod() {
            return this.method_;
        }

        public boolean isMatched(String actionName) {
            return ComponentMetaDataImpl.this.actionManager_.isMatched(actionName, this.actionNamePatterns_);
        }
    }
}

