/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.conversation;

import java.lang.reflect.Method;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.ymir.Action;
import org.seasar.ymir.ActionManager;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.IllegalClientCodeRuntimeException;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.annotation.handler.AnnotationHandler;
import org.seasar.ymir.conversation.BeginCondition;
import org.seasar.ymir.conversation.ConversationUtils;
import org.seasar.ymir.conversation.Conversations;
import org.seasar.ymir.conversation.annotation.Begin;
import org.seasar.ymir.conversation.annotation.BeginSubConversation;
import org.seasar.ymir.conversation.annotation.Conversation;
import org.seasar.ymir.conversation.annotation.End;
import org.seasar.ymir.conversation.impl.BeginSubConversationMethodInvoker;
import org.seasar.ymir.conversation.impl.EndConversationMethodInvoker;
import org.seasar.ymir.interceptor.impl.AbstractYmirProcessInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversationInterceptor
extends AbstractYmirProcessInterceptor {
    private ActionManager actionManager_;
    private ApplicationManager applicationManager_;
    private AnnotationHandler annotationHandler_;

    @Binding(bindingType=BindingType.MUST)
    public void setActionManager(ActionManager actionManager) {
        this.actionManager_ = actionManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setAnnotationHandler(AnnotationHandler annotationHandler) {
        this.annotationHandler_ = annotationHandler;
    }

    @Override
    public Action actionInvoking(Request request, Action action) {
        Conversation annotation = this.annotationHandler_.getAnnotation(request.getCurrentDispatch().getPageComponent().getPageClass(), Conversation.class);
        if (annotation != null) {
            Conversations conversations = ConversationUtils.getConversations();
            Method actionMethod = action != null ? action.getMethodInvoker().getMethod() : null;
            Begin begin = this.annotationHandler_.getAnnotation(actionMethod, Begin.class);
            if (begin != null) {
                conversations.begin(annotation.name(), annotation.phase(), begin.where());
            } else if (this.isDisableBeginCheck()) {
                conversations.begin(annotation.name(), annotation.phase(), BeginCondition.EXCEPT_FOR_SAME_CONVERSATION);
            }
            conversations.join(annotation.name(), annotation.phase(), annotation.followAfter(), this.isAcceptBrowsersBackButton(annotation.acceptBrowsersBackButton().booleanValue()));
            BeginSubConversation beginSubConversation = this.annotationHandler_.getAnnotation(actionMethod, BeginSubConversation.class);
            if (this.annotationHandler_.isAnnotationPresent(actionMethod, End.class)) {
                if (beginSubConversation != null) {
                    throw new IllegalClientCodeRuntimeException("Can't specify both @End and @BeginSubConversation: " + actionMethod.getName());
                }
                if (conversations.isInSubConversation() && !this.isValidReturnTypeAsSubConversationEndAction(action.getReturnType())) {
                    throw new IllegalClientCodeRuntimeException("@End must annote a method whose return type is Object, String or Response: " + action.getTarget().getClass().getName() + "#" + action.getName() + "()");
                }
                action = this.actionManager_.newAction(action.getTarget(), action.getTargetClass(), new EndConversationMethodInvoker(action.getMethodInvoker(), this.actionManager_));
            } else if (beginSubConversation != null) {
                action = this.actionManager_.newAction(action.getTarget(), action.getTargetClass(), new BeginSubConversationMethodInvoker(action.getMethodInvoker(), beginSubConversation));
            }
        }
        return action;
    }

    boolean isAcceptBrowsersBackButton(Boolean acceptBrowsersBackButton) {
        if (acceptBrowsersBackButton != null) {
            return acceptBrowsersBackButton;
        }
        return PropertyUtils.valueOf((String)this.applicationManager_.findContextApplication().getProperty("core.conversation.acceptBrowsersBackButton"), (boolean)false);
    }

    boolean isValidReturnTypeAsSubConversationEndAction(Class<? extends Object> returnType) {
        return returnType.isAssignableFrom(String.class) || returnType == Response.class;
    }

    S2Container getS2Container() {
        return this.applicationManager_.findContextApplication().getS2Container();
    }

    boolean isDisableBeginCheck() {
        return PropertyUtils.valueOf((String)this.applicationManager_.findContextApplication().getProperty("core.conversation.disableBeginCheck"), (boolean)false);
    }
}

