/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.batch.util;

import java.io.File;
import java.net.URL;
import org.seasar.framework.util.JarFileUtil;
import org.seasar.framework.util.ResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchUtils {
    private static final String NAME_TARGET = "target";
    private static final String PATH_SRC_MAIN_BATCH = "src/main/batch";

    private BatchUtils() {
    }

    public static File getBuildDir(Class<?> clazz) {
        return BatchUtils.getBuildDir(ResourceUtil.getResourcePath(clazz));
    }

    public static File getBuildDir(String path) {
        File dir = null;
        URL url = ResourceUtil.getResource((String)path);
        if ("file".equals(url.getProtocol())) {
            int num = path.split("/").length;
            dir = new File(ResourceUtil.getFileName((URL)url));
            int i = 0;
            while (i < num) {
                ++i;
                dir = dir.getParentFile();
            }
        } else {
            dir = new File(JarFileUtil.toJarFilePath((URL)url)).getParentFile();
        }
        return dir;
    }

    public static File getBatchHome() {
        File d;
        File dir;
        try {
            dir = BatchUtils.getBuildDir(Class.forName("org.seasar.ymir.landmark.Landmark")).getParentFile();
        }
        catch (ClassNotFoundException ex) {
            dir = BatchUtils.getBuildDir(BatchUtils.class).getParentFile();
        }
        if (NAME_TARGET.equals(dir.getName()) && (d = dir.getParentFile()) != null && (d = new File(d, PATH_SRC_MAIN_BATCH)).exists() && d.isDirectory()) {
            dir = d;
        }
        return dir;
    }
}

