/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.redirection.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.seasar.ymir.Response;
import org.seasar.ymir.ResponseType;
import org.seasar.ymir.redirection.impl.AbstractScopeIdManager;
import org.seasar.ymir.util.ResponseUtils;

public class RequestParameterScopeIdManager
extends AbstractScopeIdManager {
    public String getScopeId() {
        return this.getRequest().getParameter(this.getScopeIdKey());
    }

    public String populateScopeId(boolean scopeExists) {
        Response response;
        String scopeId = this.getScopeIdForNextRequest();
        if (scopeExists && (ResponseUtils.isProceed(response = this.getResponse()) || response.getType() == ResponseType.REDIRECT)) {
            String path = response.getPath();
            StringBuilder sb = new StringBuilder();
            sb.append(path);
            int question = path.indexOf(63);
            if (question < 0) {
                sb.append("?");
            } else if (question < path.length() - 1) {
                sb.append("&");
            }
            try {
                sb.append(this.getScopeIdKey()).append("=").append(URLEncoder.encode(scopeId, this.getRequest().getCharacterEncoding()));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            response.setPath(sb.toString());
        }
        return scopeId;
    }
}

