/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.handler.impl;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.kvasir.util.PropertyUtils;
import org.seasar.kvasir.util.io.IORuntimeException;
import org.seasar.ymir.ActionNotFoundRuntimeException;
import org.seasar.ymir.Dispatch;
import org.seasar.ymir.HttpMethod;
import org.seasar.ymir.MatchedPathMapping;
import org.seasar.ymir.Request;
import org.seasar.ymir.Response;
import org.seasar.ymir.Ymir;
import org.seasar.ymir.YmirContext;
import org.seasar.ymir.handler.annotation.ExceptionHandler;

public class ActionNotFoundRuntimeExceptionHandler {
    private static final String HEADER_ALLOW = "Allow";
    private Request request_;
    private HttpServletResponse httpResponse_;

    @Binding(bindingType=BindingType.MUST)
    public void setRequest(Request request) {
        this.request_ = request;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setHttpResponse(HttpServletResponse httpResponse) {
        this.httpResponse_ = httpResponse;
    }

    @ExceptionHandler
    public Response handle(ActionNotFoundRuntimeException t) {
        this.httpResponse_.setHeader(HEADER_ALLOW, PropertyUtils.join((String[])this.getAllowedMethods()));
        try {
            this.httpResponse_.sendError(405);
            return null;
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    String[] getAllowedMethods() {
        Ymir ymir = this.getYmir();
        Dispatch dispatch = this.request_.getCurrentDispatch();
        String path = dispatch.getPath();
        ArrayList<String> list = new ArrayList<String>();
        for (HttpMethod method : HttpMethod.values()) {
            MatchedPathMapping matched = ymir.findMatchedPathMapping(path, method);
            if (matched == null || matched.getAction(dispatch.getPageComponent(), this.request_) == null) continue;
            list.add(method.name());
        }
        return list.toArray(new String[0]);
    }

    Ymir getYmir() {
        return YmirContext.getYmir();
    }
}

