/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.ymir.beantable;

import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.cms.beantable.Beantable;
import org.seasar.cms.pluggable.ClassTraverser;
import org.seasar.cms.pluggable.hotdeploy.DistributedHotdeployBehavior;
import org.seasar.cms.pluggable.hotdeploy.HotdeployListener;
import org.seasar.cms.pluggable.util.PluggableUtils;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.impl.S2ContainerBehavior;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.ymir.Application;
import org.seasar.ymir.ApplicationManager;
import org.seasar.ymir.LifecycleListener;
import org.seasar.ymir.annotation.handler.AnnotationHandler;
import org.seasar.ymir.beantable.BeantableClassHandler;
import org.seasar.ymir.beantable.ClassTraverserBag;
import org.seasar.ymir.beantable.annotation.Managed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeantableManager
implements LifecycleListener,
HotdeployListener {
    private S2Container container_;
    private ApplicationManager applicationManager_;
    private AnnotationHandler annotationHandler_;
    private ClassTraversal.ClassHandler beantableClassHandler_;
    private ClassTraverserBag[] traverserBags_;
    private Log log_ = LogFactory.getLog(BeantableManager.class);

    @Binding(bindingType=BindingType.MUST)
    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager_ = applicationManager;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setAnnotationHandler(AnnotationHandler annotationHandler) {
        this.annotationHandler_ = annotationHandler;
    }

    @Binding(bindingType=BindingType.MUST, value="beantableClassHandler")
    public void setBeantableClassHandler(BeantableClassHandler beantableClassHandler) {
        this.beantableClassHandler_ = beantableClassHandler;
    }

    public void init() {
        ArrayList<ClassTraverserBag> bagList = new ArrayList<ClassTraverserBag>();
        Application[] applications = this.applicationManager_.getApplications();
        for (int i = 0; i < applications.length; ++i) {
            if (!this.isEnabled(applications[i])) continue;
            ClassTraverserBag bag = this.newClassTraverserBag(applications[i]);
            bagList.add(bag);
        }
        this.traverserBags_ = bagList.toArray(new ClassTraverserBag[0]);
        this.traserse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void traserse() {
        DistributedHotdeployBehavior behavior = (DistributedHotdeployBehavior)S2ContainerBehavior.getProvider();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        behavior.start();
        try {
            Thread.currentThread().setContextClassLoader(PluggableUtils.adjustClassLoader((DistributedHotdeployBehavior)behavior, (ClassLoader)classLoader));
            for (int i = 0; i < this.traverserBags_.length; ++i) {
                this.traverserBags_[i].getClassTraverser().traverse();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
            behavior.stop();
        }
    }

    ClassTraverserBag newClassTraverserBag(Application application) {
        ClassTraverser traverser = new ClassTraverser();
        traverser.setClassHandler(this.beantableClassHandler_);
        String targetPackageName = application.getFirstRootPackageName() + ".dao";
        traverser.addClassPattern(targetPackageName, ".*");
        traverser.addIgnoreClassPattern(targetPackageName, "(Abstract)?.*(Base|Dao)");
        for (Class referenceClass : application.getReferenceClasses()) {
            traverser.addReferenceClass(referenceClass);
        }
        return new ClassTraverserBag(traverser, application);
    }

    boolean isEnabled(Application application) {
        return "true".equals(application.getProperty("beantable.enable")) && application.getReferenceClasses().length > 0;
    }

    public void enableBeantable(Class<?> clazz, boolean correctTableSchema) {
        ClassTraverserBag bag = this.getClassTraverserBag(clazz);
        if (bag == null) {
            return;
        }
        if (!this.isEnabled(bag.getApplication())) {
            return;
        }
        if (!this.isBeanClass(clazz, bag.getClassTraverser())) {
            return;
        }
        if (!this.isManaged(clazz)) {
            return;
        }
        Beantable beantable = this.newBeantable(clazz);
        try {
            beantable.activate();
        }
        catch (SQLException ex) {
            this.log_.error((Object)("Can't activate table: " + clazz.getName()), (Throwable)ex);
        }
        try {
            beantable.update(correctTableSchema);
        }
        catch (SQLException ex) {
            this.log_.error((Object)("Can't update table: " + clazz.getName()), (Throwable)ex);
        }
    }

    public void destroy() {
    }

    public void definedClass(Class clazz) {
        this.enableBeantable(clazz, true);
    }

    ClassTraverserBag getClassTraverserBag(Class<?> clazz) {
        if (this.traverserBags_ != null) {
            for (int i = 0; i < this.traverserBags_.length; ++i) {
                if (!this.traverserBags_[i].getApplication().isCapable(clazz)) continue;
                return this.traverserBags_[i];
            }
        }
        return null;
    }

    boolean isBeanClass(Class<?> clazz, ClassTraverser traverser) {
        String shortClassName;
        String packageName;
        String className = clazz.getName();
        int dot = className.lastIndexOf(46);
        if (dot < 0) {
            packageName = "";
            shortClassName = className;
        } else {
            packageName = className.substring(0, dot);
            shortClassName = className.substring(dot + 1);
        }
        return traverser.isMatched(packageName, shortClassName);
    }

    Beantable newBeantable(Class beanClass) {
        Beantable beanTable = (Beantable)this.container_.getComponent(Beantable.class);
        beanTable.setBeanClass(beanClass);
        return beanTable;
    }

    boolean isManaged(Class<?> beanClass) {
        Managed managed = (Managed)this.annotationHandler_.getAnnotation(beanClass, Managed.class);
        return managed != null && managed.value();
    }
}

