/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.annotation.handler;

import java.lang.reflect.Field;
import java.util.Map;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.teeda.extension.ExtensionConstants;
import org.seasar.teeda.extension.annotation.handler.ConstantScopeAnnotationHandler;
import org.seasar.teeda.extension.annotation.scope.PageScope;
import org.seasar.teeda.extension.annotation.scope.RedirectScope;
import org.seasar.teeda.extension.annotation.scope.SubapplicationScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TigerScopeAnnotationHandler
extends ConstantScopeAnnotationHandler {
    public void setupPropertyScopes(BeanDesc beanDesc, Map scopes) {
        for (int i = 0; i < beanDesc.getFieldSize(); ++i) {
            Field field = beanDesc.getField(i);
            this.handlePageScope(field, scopes);
            this.handleRedirectScope(field, scopes);
            this.handleSubapplicationScope(field, scopes);
        }
        super.setupPropertyScopes(beanDesc, scopes);
    }

    protected void handlePageScope(Field field, Map<String, Integer> scopes) {
        PageScope pageScope = field.getAnnotation(PageScope.class);
        if (pageScope != null) {
            scopes.put(field.getName(), ExtensionConstants.PAGE_SCOPE);
        }
    }

    protected void handleRedirectScope(Field field, Map<String, Integer> scopes) {
        RedirectScope redirectScope = field.getAnnotation(RedirectScope.class);
        if (redirectScope != null) {
            scopes.put(field.getName(), ExtensionConstants.REDIRECT_SCOPE);
        }
    }

    protected void handleSubapplicationScope(Field field, Map<String, Integer> scopes) {
        SubapplicationScope subapplicationScope = field.getAnnotation(SubapplicationScope.class);
        if (subapplicationScope != null) {
            scopes.put(field.getName(), ExtensionConstants.SUBAPP_SCOPE);
        }
    }
}

