/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.assembler.impl;

import javax.faces.application.Application;
import javax.faces.event.ActionListener;
import junit.textui.TestRunner;
import org.seasar.teeda.core.config.faces.assembler.impl.ActionListenerAssembler;
import org.seasar.teeda.core.mock.MockActionListener;
import org.seasar.teeda.core.mock.MockApplication;
import org.seasar.teeda.core.mock.MockSingleConstructorActionListener;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class ActionListenerAssemblerTest
extends TeedaTestCase {
    public static void main(String[] args) {
        TestRunner.run((Class)ActionListenerAssemblerTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ActionListenerAssemblerTest(String arg0) {
        super(arg0);
    }

    public void testSimpleAssembleActionListener() {
        MockApplication application = this.getApplication();
        String listenerName = "org.seasar.teeda.core.mock.MockActionListener";
        ActionListenerAssembler assembler = new ActionListenerAssembler(listenerName, (Application)application);
        assembler.assemble();
        ActionListenerAssemblerTest.assertNotNull((Object)application.getActionListener());
        ActionListener listener = application.getActionListener();
        ActionListenerAssemblerTest.assertTrue((boolean)(listener instanceof MockActionListener));
    }

    public void testMarshalAssembleActionListener1() {
        MockApplication application = this.getApplication();
        String listenerName = "org.seasar.teeda.core.mock.MockSingleConstructorActionListener";
        ActionListenerAssembler assembler = new ActionListenerAssembler(listenerName, (Application)application);
        assembler.assemble();
        ActionListenerAssemblerTest.assertNotNull((Object)application.getActionListener());
        ActionListener listener = application.getActionListener();
        ActionListenerAssemblerTest.assertTrue((boolean)(listener instanceof MockSingleConstructorActionListener));
    }

    public void testMarshalAssembleActionListener2() {
        MockApplication application = this.getApplication();
        MockActionListener original = new MockActionListener();
        application.setActionListener((ActionListener)original);
        String listenerName = "org.seasar.teeda.core.mock.MockSingleConstructorActionListener";
        ActionListenerAssembler assembler = new ActionListenerAssembler(listenerName, (Application)application);
        assembler.assemble();
        ActionListenerAssemblerTest.assertNotNull((Object)application.getActionListener());
        ActionListener listener = application.getActionListener();
        ActionListenerAssemblerTest.assertTrue((boolean)(listener instanceof MockSingleConstructorActionListener));
        MockSingleConstructorActionListener l = (MockSingleConstructorActionListener)listener;
        ActionListenerAssemblerTest.assertTrue((boolean)(l.getOriginal() instanceof MockActionListener));
    }

    public void testMarshalAssembleActionListener3() {
        MockApplication application = this.getApplication();
        MockSingleConstructorActionListener original = new MockSingleConstructorActionListener((ActionListener)new MockActionListener());
        application.setActionListener((ActionListener)original);
        String listenerName = "org.seasar.teeda.core.mock.MockActionListener";
        ActionListenerAssembler assembler = new ActionListenerAssembler(listenerName, (Application)application);
        assembler.assemble();
        ActionListenerAssemblerTest.assertNotNull((Object)application.getActionListener());
        ActionListener listener = application.getActionListener();
        ActionListenerAssemblerTest.assertTrue((boolean)(listener instanceof MockActionListener));
    }
}

