/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.util.ArrayList;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.AbstractConverterTestCase;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.FloatConverter;
import org.seasar.teeda.core.mock.MockUIComponent;

public class FloatConverterTest
extends AbstractConverterTestCase {
    public void testGetAsObject_convertSuccess() throws Exception {
        Converter converter = this.createConverter();
        Object target = converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), "1.2F");
        FloatConverterTest.assertNotNull((Object)target);
        FloatConverterTest.assertTrue((boolean)(target instanceof Float));
        Float f = (Float)target;
        FloatConverterTest.assertTrue((f.floatValue() == 1.2f ? 1 : 0) != 0);
    }

    public void testGetAsObject_convertFail() throws Exception {
        Converter converter = this.createConverter();
        try {
            converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), "hoge");
            FloatConverterTest.fail();
        }
        catch (ConverterException expected) {
            FloatConverterTest.success();
        }
    }

    public void testGetAsString_convertSuccess() throws Exception {
        Converter converter = this.createConverter();
        String s = converter.getAsString((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), (Object)new Float(2.3f));
        FloatConverterTest.assertEquals((String)"2.3", (String)s);
    }

    public void testGetAsString_convertFail() throws Exception {
        Converter converter = this.createConverter();
        try {
            converter.getAsString((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), new ArrayList());
            FloatConverterTest.fail();
        }
        catch (ConverterException expected) {
            FloatConverterTest.success();
        }
    }

    public void testGetAsObject_convertWithDelimeter() throws Exception {
        Converter converter = this.createConverter();
        String value = "1,000.2F";
        Object target = converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), value);
        FloatConverterTest.assertNotNull((Object)target);
        FloatConverterTest.assertTrue((boolean)(target instanceof Float));
        Float f = (Float)target;
        FloatConverterTest.assertTrue((f.floatValue() == 1000.2f ? 1 : 0) != 0);
    }

    public void testConstants() throws Exception {
        FloatConverterTest.assertEquals((String)"javax.faces.Float", (String)"javax.faces.Float");
    }

    protected Converter createConverter() {
        return this.createFloatConverter();
    }

    protected FloatConverter createFloatConverter() {
        return new FloatConverter();
    }
}

