/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.convert.AbstractConverterTestCase;
import javax.faces.convert.ByteConverter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockUIComponent;

public class ByteConverterTest
extends AbstractConverterTestCase {
    public void testGetAsObject_convertSuccess() {
        Converter converter = this.createConverter();
        MockUIComponent component = new MockUIComponent();
        MockFacesContext context = this.getFacesContext();
        String value = "126";
        Object o = converter.getAsObject((FacesContext)context, (UIComponent)component, value);
        ByteConverterTest.assertTrue((boolean)(o instanceof Byte));
        Byte b = (Byte)o;
        ByteConverterTest.assertEquals((byte)Byte.parseByte(value), (byte)b);
    }

    public void testGetAsObject_convertFail() throws Exception {
        Converter converter = this.createConverter();
        MockUIComponent component = new MockUIComponent();
        MockFacesContext context = this.getFacesContext();
        String value = "128";
        UIViewRoot viewRoot = new UIViewRoot();
        viewRoot.setLocale(Locale.getDefault());
        context.setViewRoot(viewRoot);
        try {
            converter.getAsObject((FacesContext)context, (UIComponent)component, value);
            ByteConverterTest.fail();
        }
        catch (ConverterException e) {
            ByteConverterTest.success();
        }
    }

    public void testGetAsString_convertSuccess() {
        Converter converter = this.createConverter();
        MockUIComponent component = new MockUIComponent();
        MockFacesContext context = this.getFacesContext();
        String value = "1";
        String str = converter.getAsString((FacesContext)context, (UIComponent)component, (Object)value);
        ByteConverterTest.assertEquals((byte)Byte.parseByte(value), (byte)Byte.parseByte(str));
    }

    public void testGetAsString_convertFail() {
        Converter converter = this.createConverter();
        MockUIComponent component = new MockUIComponent();
        MockFacesContext context = this.getFacesContext();
        Long l = new Long(123456789L);
        try {
            converter.getAsString((FacesContext)context, (UIComponent)component, (Object)l);
            ByteConverterTest.fail();
        }
        catch (ConverterException e) {
            ByteConverterTest.success();
        }
    }

    public void testConstants() throws Exception {
        ByteConverterTest.assertEquals((String)"javax.faces.Byte", (String)"javax.faces.Byte");
    }

    protected Converter createConverter() {
        return this.createByteConverter();
    }

    protected ByteConverter createByteConverter() {
        return new ByteConverter();
    }
}

