/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import org.custommonkey.xmlunit.Diff;
import org.seasar.teeda.core.mock.MockConverter;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockHtmlInputText;
import org.seasar.teeda.core.mock.MockUIComponentBaseWithNamingContainer;
import org.seasar.teeda.core.render.html.HtmlInputTextRenderer;

public class HtmlInputTextRendererTest
extends RendererTest {
    private HtmlInputTextRenderer renderer;
    private MockHtmlInputText htmlInputText;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlInputTextRenderer();
        this.htmlInputText = (MockHtmlInputText)this.createUIInput();
        this.htmlInputText.setRenderer((Renderer)this.renderer);
    }

    protected UIInput createUIInput() {
        return new MockHtmlInputText();
    }

    public void testEncode_NoValue() throws Exception {
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputText);
        HtmlInputTextRendererTest.assertEquals((String)"<input type=\"text\" name=\"_id0\" value=\"\" />", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlInputText.setRendered(false);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputText);
        HtmlInputTextRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_WithValue() throws Exception {
        this.htmlInputText.setValue("abc");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputText);
        HtmlInputTextRendererTest.assertEquals((String)"<input type=\"text\" name=\"_id0\" value=\"abc\" />", (String)this.getResponseText());
    }

    public void testEncode_WithValue2() throws Exception {
        this.htmlInputText.setValue("&hearts;");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputText);
        HtmlInputTextRendererTest.assertEquals((String)"<input type=\"text\" name=\"_id0\" value=\"&amp;hearts;\" />", (String)this.getResponseText());
    }

    public void testEncode_WithId() throws Exception {
        this.htmlInputText.setId("a");
        MockUIComponentBaseWithNamingContainer parent = new MockUIComponentBaseWithNamingContainer();
        parent.setId("b");
        parent.getChildren().add(this.htmlInputText);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputText);
        HtmlInputTextRendererTest.assertEquals((String)"<input type=\"text\" id=\"a\" name=\"b:a\" value=\"\" />", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute1() throws Exception {
        this.htmlInputText.setId("a");
        this.htmlInputText.getAttributes().put("bbb", "ccc");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputText);
        HtmlInputTextRendererTest.assertEquals((String)"<input type=\"text\" id=\"a\" name=\"a\" value=\"\" bbb=\"ccc\" />", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute2() throws Exception {
        this.htmlInputText.setId("a");
        this.htmlInputText.getAttributes().put("b.b", "ccc");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputText);
        HtmlInputTextRendererTest.assertEquals((String)"<input type=\"text\" id=\"a\" name=\"a\" value=\"\" />", (String)this.getResponseText());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        this.htmlInputText.setAccesskey("a");
        this.htmlInputText.setAlt("b");
        this.htmlInputText.setDir("c");
        this.htmlInputText.setDisabled(true);
        this.htmlInputText.setLang("e");
        this.htmlInputText.setMaxlength(5);
        this.htmlInputText.setOnblur("g");
        this.htmlInputText.setOnchange("h");
        this.htmlInputText.setOnclick("i");
        this.htmlInputText.setOndblclick("j");
        this.htmlInputText.setOnfocus("k");
        this.htmlInputText.setOnkeydown("l");
        this.htmlInputText.setOnkeypress("m");
        this.htmlInputText.setOnkeyup("n");
        this.htmlInputText.setOnmousedown("o");
        this.htmlInputText.setOnmousemove("p");
        this.htmlInputText.setOnmouseout("q");
        this.htmlInputText.setOnmouseover("r");
        this.htmlInputText.setOnmouseup("s");
        this.htmlInputText.setOnselect("t");
        this.htmlInputText.setReadonly(true);
        this.htmlInputText.setSize(2);
        this.htmlInputText.setStyle("w");
        this.htmlInputText.setStyleClass("u");
        this.htmlInputText.setTabindex("x");
        this.htmlInputText.setTitle("y");
        this.htmlInputText.getAttributes().put("type", "hidden");
        this.htmlInputText.getAttributes().put("name", "hoge");
        this.htmlInputText.setId("A");
        this.htmlInputText.setValue("B");
        this.htmlInputText.setAutocomplete("C");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputText);
        Diff diff = new Diff("<input type=\"text\" id=\"A\" name=\"A\" value=\"B\" accesskey=\"a\" alt=\"b\" dir=\"c\" disabled=\"disabled\" lang=\"e\" maxlength=\"5\" onblur=\"g\" onchange=\"h\" onclick=\"i\" ondblclick=\"j\" onfocus=\"k\" onkeydown=\"l\" onkeypress=\"m\" onkeyup=\"n\" onmousedown=\"o\" onmousemove=\"p\" onmouseout=\"q\" onmouseover=\"r\" onmouseup=\"s\" onselect=\"t\" readonly=\"readonly\" size=\"2\" style=\"w\" class=\"u\" tabindex=\"x\" title=\"y\" autocomplete=\"C\"/>", this.getResponseText());
        HtmlInputTextRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testDecode_None() throws Exception {
        this.htmlInputText.setClientId("key");
        MockFacesContext context = this.getFacesContext();
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlInputText);
        HtmlInputTextRendererTest.assertEquals(null, (Object)this.htmlInputText.getSubmittedValue());
    }

    public void testDecode_Success() throws Exception {
        this.htmlInputText.setClientId("key");
        MockFacesContext context = this.getFacesContext();
        context.getExternalContext().getRequestParameterMap().put("key", "12345");
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlInputText);
        HtmlInputTextRendererTest.assertEquals((Object)"12345", (Object)this.htmlInputText.getSubmittedValue());
    }

    public void testEncode_Converter() throws Exception {
        MockConverter converter = new MockConverter(){

            public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
                return value + "ddd";
            }
        };
        this.htmlInputText.setValue("abc");
        this.htmlInputText.setConverter((Converter)converter);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputText);
        HtmlInputTextRendererTest.assertEquals((String)"<input type=\"text\" name=\"_id0\" value=\"abcddd\" />", (String)this.getResponseText());
    }

    public void testGetConvertedValue() throws Exception {
        MockConverter converter = new MockConverter(){

            public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
                return value + ".testGetConvertedValue";
            }
        };
        this.htmlInputText.setConverter((Converter)converter);
        Object convertedValue = this.renderer.getConvertedValue((FacesContext)this.getFacesContext(), (UIComponent)this.htmlInputText, (Object)"aaa");
        HtmlInputTextRendererTest.assertEquals((Object)"aaa.testGetConvertedValue", (Object)convertedValue);
    }

    public void testGetRendersChildren() throws Exception {
        HtmlInputTextRendererTest.assertEquals((boolean)false, (boolean)this.renderer.getRendersChildren());
    }

    private HtmlInputTextRenderer createHtmlInputTextRenderer() {
        return (HtmlInputTextRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlInputTextRenderer renderer = new HtmlInputTextRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }
}

