/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.IntegerConverter;
import javax.faces.el.ValueBinding;
import junitx.framework.ArrayAssert;
import org.seasar.teeda.core.context.html.HtmlResponseWriter;
import org.seasar.teeda.core.mock.MockConverter;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockFacesContextImpl;
import org.seasar.teeda.core.mock.MockUIComponent;
import org.seasar.teeda.core.mock.MockUIComponentBase;
import org.seasar.teeda.core.mock.MockValueBinding;
import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.core.util.RendererUtil;

public class RendererUtilTest
extends TeedaTestCase {
    public void testRenderAttribute() throws Exception {
        HtmlResponseWriter writer = new HtmlResponseWriter();
        writer.setWriter((Writer)new StringWriter());
        HtmlInputText htmlInputText = new HtmlInputText();
        writer.startElement("input", (UIComponent)htmlInputText);
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"readonly", (Object)"true");
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"disabled", (Object)"true");
        writer.endElement("input");
        RendererUtilTest.assertEquals((String)"<input readonly=\"readonly\" disabled=\"disabled\" />", (String)writer.toString());
    }

    public void testShouldRenderIdAttribute_True() throws Exception {
        MockUIComponent component = new MockUIComponent();
        component.setId("_idaaa");
        RendererUtilTest.assertEquals((boolean)false, (boolean)RendererUtil.shouldRenderIdAttribute((UIComponent)component));
    }

    public void testShouldRenderIdAttribute_False() throws Exception {
        MockUIComponent component = new MockUIComponent();
        component.setId("aaa");
        RendererUtilTest.assertEquals((boolean)true, (boolean)RendererUtil.shouldRenderIdAttribute((UIComponent)component));
    }

    public void testShouldRenderIdAttribute_False_IdIsNull() throws Exception {
        MockUIComponent component = new MockUIComponent();
        component.setId(null);
        RendererUtilTest.assertEquals((boolean)false, (boolean)RendererUtil.shouldRenderIdAttribute((UIComponent)component));
    }

    public void testIsDefaultValue() throws Exception {
        RendererUtilTest.assertEquals((boolean)true, (boolean)RendererUtil.isDefaultAttributeValue(null));
        RendererUtilTest.assertEquals((boolean)true, (boolean)RendererUtil.isDefaultAttributeValue((Object)Boolean.FALSE));
        RendererUtilTest.assertEquals((boolean)true, (boolean)RendererUtil.isDefaultAttributeValue((Object)new Integer(Integer.MIN_VALUE)));
        RendererUtilTest.assertEquals((boolean)false, (boolean)RendererUtil.isDefaultAttributeValue((Object)Boolean.TRUE));
        RendererUtilTest.assertEquals((boolean)false, (boolean)RendererUtil.isDefaultAttributeValue((Object)new Integer(0)));
        RendererUtilTest.assertEquals((boolean)false, (boolean)RendererUtil.isDefaultAttributeValue((Object)new Integer(-1)));
        RendererUtilTest.assertEquals((boolean)false, (boolean)RendererUtil.isDefaultAttributeValue((Object)new Integer(1)));
        RendererUtilTest.assertEquals((boolean)false, (boolean)RendererUtil.isDefaultAttributeValue((Object)new Integer(Integer.MAX_VALUE)));
        RendererUtilTest.assertEquals((boolean)false, (boolean)RendererUtil.isDefaultAttributeValue((Object)""));
    }

    public void testContainsAttributes_false() throws Exception {
        MockUIComponentBase component = new MockUIComponentBase();
        RendererUtilTest.assertEquals((boolean)false, (boolean)RendererUtil.containsAttributesForRender((UIComponent)component, (String[])new String[]{"foo"}));
    }

    public void testContainsAttributes_true() throws Exception {
        MockUIComponentBase component = new MockUIComponentBase();
        component.getAttributes().put("foo", "something");
        RendererUtilTest.assertEquals((boolean)true, (boolean)RendererUtil.containsAttributesForRender((UIComponent)component, (String[])new String[]{"foo"}));
    }

    public void testContainsAttributes_falseWhenDefaultValue() throws Exception {
        MockUIComponentBase component = new MockUIComponentBase();
        component.getAttributes().put("rendered", Boolean.FALSE);
        RendererUtilTest.assertEquals((boolean)false, (boolean)RendererUtil.containsAttributesForRender((UIComponent)component, (String[])new String[]{"rendered"}));
    }

    public void testGetConvertedUIOutputValues_submittedValueIsNull() throws Exception {
        RendererUtilTest.assertNull((Object)RendererUtil.getConvertedUIOutputValues((FacesContext)new MockFacesContextImpl(), (UIOutput)new UIOutput(), null));
    }

    public void testGetConvertedUIOutputValues_converterIsNull() throws Exception {
        UIOutput out = new UIOutput();
        out.setConverter(null);
        Object o = RendererUtil.getConvertedUIOutputValues((FacesContext)new MockFacesContextImpl(), (UIOutput)out, (Object)"aaa");
        RendererUtilTest.assertEquals((Object)"aaa", (Object)o);
    }

    public void testGetConvertedUIOutputValues_arrayLengthIsZero() throws Exception {
        UIOutput out = new UIOutput();
        out.setConverter((Converter)new MockConverter());
        MockValueBinding vb = new MockValueBinding();
        vb.setType([I.class);
        out.setValueBinding("value", (ValueBinding)vb);
        Object submittedValue = Array.newInstance(Integer.TYPE, 0);
        Object o = RendererUtil.getConvertedUIOutputValues((FacesContext)new MockFacesContextImpl(), (UIOutput)out, (Object)submittedValue);
        int[] result = (int[])o;
        RendererUtilTest.assertEquals((int)0, (int)result.length);
    }

    public void testGetConvertedUIOutputValues_arrayReturn() throws Exception {
        UIOutput out = new UIOutput();
        out.setConverter((Converter)new IntegerConverter());
        MockValueBinding vb = new MockValueBinding();
        vb.setType([I.class);
        out.setValueBinding("value", (ValueBinding)vb);
        Object submittedValue = Array.newInstance(String.class, 3);
        Array.set(submittedValue, 0, "1");
        Array.set(submittedValue, 1, "2");
        Array.set(submittedValue, 2, "3");
        Object o = RendererUtil.getConvertedUIOutputValues((FacesContext)new MockFacesContextImpl(), (UIOutput)out, (Object)submittedValue);
        int[] result = (int[])o;
        RendererUtilTest.assertEquals((int)3, (int)result.length);
        ArrayAssert.assertEquals((int[])new int[]{1, 2, 3}, (int[])result);
    }

    public void testRenderChild1() throws Exception {
        MockFacesContext context = this.getFacesContext();
        final boolean[] calls = new boolean[]{false, false, false};
        MockUIComponent child = new MockUIComponent(){

            public void encodeBegin(FacesContext context) throws IOException {
                calls[0] = true;
            }

            public void encodeChildren(FacesContext context) throws IOException {
                calls[1] = true;
            }

            public void encodeEnd(FacesContext context) throws IOException {
                calls[2] = true;
            }

            public boolean getRendersChildren() {
                return true;
            }
        };
        RendererUtil.renderChild((FacesContext)context, (UIComponent)child);
        RendererUtilTest.assertTrue((boolean)calls[0]);
        RendererUtilTest.assertTrue((boolean)calls[1]);
        RendererUtilTest.assertTrue((boolean)calls[2]);
    }

    public void testRenderChild2() throws Exception {
        MockFacesContext context = this.getFacesContext();
        final boolean[] calls = new boolean[]{false, false, false};
        MockUIComponent child = new MockUIComponent(){

            public void encodeBegin(FacesContext context) throws IOException {
                calls[0] = true;
            }

            public void encodeChildren(FacesContext context) throws IOException {
                calls[1] = true;
            }

            public void encodeEnd(FacesContext context) throws IOException {
                calls[2] = true;
            }

            public boolean getRendersChildren() {
                return false;
            }
        };
        RendererUtil.renderChild((FacesContext)context, (UIComponent)child);
        RendererUtilTest.assertTrue((boolean)calls[0]);
        RendererUtilTest.assertFalse((boolean)calls[1]);
        RendererUtilTest.assertTrue((boolean)calls[2]);
    }

    public void testRenderChildlen1() throws Exception {
        MockFacesContext context = this.getFacesContext();
        final boolean[] calls = new boolean[]{false, false, false};
        MockUIComponent child = new MockUIComponent(){

            public void encodeBegin(FacesContext context) throws IOException {
                calls[0] = true;
            }

            public void encodeChildren(FacesContext context) throws IOException {
                calls[1] = true;
            }

            public void encodeEnd(FacesContext context) throws IOException {
                calls[2] = true;
            }

            public boolean getRendersChildren() {
                return true;
            }
        };
        MockUIComponent parent = new MockUIComponent();
        parent.getChildren().add(child);
        RendererUtil.renderChildren((FacesContext)context, (UIComponent)parent);
        RendererUtilTest.assertTrue((boolean)calls[0]);
        RendererUtilTest.assertTrue((boolean)calls[1]);
        RendererUtilTest.assertTrue((boolean)calls[2]);
    }
}

