/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import javax.faces.context.ExternalContext;
import javax.servlet.ServletContext;
import junit.framework.TestCase;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockHttpServletRequestImpl;
import org.seasar.framework.mock.servlet.MockServletContext;
import org.seasar.framework.mock.servlet.MockServletContextImpl;
import org.seasar.teeda.core.mock.MockExternalContextImpl;
import org.seasar.teeda.core.util.ExternalContextUtil;

public class ExternalContextUtilTest
extends TestCase {
    public void testGetViewId_getFromRequestPathInfo() throws Exception {
        MockExternalContextImpl context = new MockExternalContextImpl();
        MockHttpServletRequestImpl request = new MockHttpServletRequestImpl((ServletContext)new MockServletContextImpl("/context"), "/bbb");
        request.setPathInfo("aaa");
        context.setMockHttpServletRequest((MockHttpServletRequest)request);
        ExternalContextUtilTest.assertEquals((String)"aaa", (String)ExternalContextUtil.getViewId((ExternalContext)context));
    }

    public void testGetViewId_servletPath() throws Exception {
        MockExternalContextImpl context = new MockExternalContextImpl();
        MockHttpServletRequestImpl request = new MockHttpServletRequestImpl((ServletContext)new MockServletContextImpl("/context"), "/bbb");
        context.setMockHttpServletRequest((MockHttpServletRequest)request);
        ExternalContextUtilTest.assertEquals((String)"/bbb", (String)ExternalContextUtil.getViewId((ExternalContext)context));
    }

    public void testGetViewId_servletPath2() throws Exception {
        MockExternalContextImpl context = new MockExternalContextImpl();
        MockHttpServletRequestImpl request = new MockHttpServletRequestImpl((ServletContext)new MockServletContextImpl("/context"), "/bbb.html");
        context.setMockHttpServletRequest((MockHttpServletRequest)request);
        ExternalContextUtilTest.assertEquals((String)"/bbb.jsp", (String)ExternalContextUtil.getViewId((ExternalContext)context));
    }

    public void testGetViewId_initParameter() throws Exception {
        MockExternalContextImpl context = new MockExternalContextImpl();
        MockServletContextImpl servletContext = new MockServletContextImpl("/context");
        servletContext.setInitParameter("javax.faces.DEFAULT_SUFFIX", ".html");
        MockHttpServletRequestImpl request = new MockHttpServletRequestImpl((ServletContext)servletContext, "/bbb.hoge");
        context.setMockHttpServletRequest((MockHttpServletRequest)request);
        context.setMockServletContext((MockServletContext)servletContext);
        ExternalContextUtilTest.assertEquals((String)"/bbb.html", (String)ExternalContextUtil.getViewId((ExternalContext)context));
    }
}

