/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render;

import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.seasar.teeda.core.mock.MockExternalContextImpl;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockFacesContextImpl;
import org.seasar.teeda.core.mock.MockUIComponent;
import org.seasar.teeda.core.render.DefaultComponentIdLookupStrategy;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class DefaultComponentIdLookupStrategyTest
extends TeedaTestCase {
    public void test1() throws Exception {
        DefaultComponentIdLookupStrategy strategy = new DefaultComponentIdLookupStrategy();
        MockUIComponent component = new MockUIComponent();
        component.setId("a");
        DefaultComponentIdLookupStrategyTest.assertEquals((String)"a", (String)strategy.getId((FacesContext)new MockFacesContextImpl(), (UIComponent)component));
    }

    public void test2() throws Exception {
        DefaultComponentIdLookupStrategy strategy = new DefaultComponentIdLookupStrategy();
        MockUIComponent component = new MockUIComponent();
        component.setClientId("a");
        DefaultComponentIdLookupStrategyTest.assertEquals((String)"a", (String)strategy.getId((FacesContext)new MockFacesContextImpl(), (UIComponent)component));
    }

    public void test3() throws Exception {
        DefaultComponentIdLookupStrategy strategy = new DefaultComponentIdLookupStrategy();
        MockUIComponent component = new MockUIComponent();
        component.setId("a");
        component.setClientId("b");
        DefaultComponentIdLookupStrategyTest.assertEquals((String)"a", (String)strategy.getId((FacesContext)new MockFacesContextImpl(), (UIComponent)component));
    }

    public void testGetId_withNamespace() throws Exception {
        DefaultComponentIdLookupStrategy strategy = new DefaultComponentIdLookupStrategy();
        MockExternalContextImpl externalContext = new MockExternalContextImpl(){

            public String encodeNamespace(String value) {
                return "encode:" + value;
            }
        };
        MockFacesContext context = this.getFacesContext();
        context.setExternalContext((ExternalContext)externalContext);
        MockUIComponent mock = new MockUIComponent();
        mock.setId("aaa");
        String id = strategy.getId((FacesContext)context, (UIComponent)mock);
        DefaultComponentIdLookupStrategyTest.assertEquals((String)"encode:aaa", (String)id);
    }
}

