/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.application.StateManager;
import javax.faces.internal.FacesConfigOptions;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.teeda.core.render.Base64EncodeConverter;
import org.seasar.teeda.core.render.html.StructureAndState;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class Base64EncodeConverterTest
extends TeedaTestCase {
    public void testDecode_blank() throws Exception {
        Base64EncodeConverter converter = new Base64EncodeConverter();
        String encoded = converter.getAsEncodeString((Object)"");
        System.out.println(encoded);
        Object decoded = converter.getAsDecodeObject(encoded);
        System.out.println(decoded);
    }

    public void testEncodeAndDecode() throws Exception {
        Base64EncodeConverter encodeConverter = new Base64EncodeConverter();
        String encoded = encodeConverter.getAsEncodeString((Object)new Integer(7650));
        Object decoded = encodeConverter.getAsDecodeObject(encoded);
        Base64EncodeConverterTest.assertEquals((Object)new Integer(7650), (Object)decoded);
    }

    public void testEncodeAndDecode_NoCompressed() throws Exception {
        StateManager stateManager = this.getApplication().getStateManager();
        stateManager.getClass();
        StateManager.SerializedView serializedView = new StateManager.SerializedView(stateManager, (Object)new AAA("aaaStructure"), (Object)new AAA("bbbState"));
        Base64EncodeConverter converter = new Base64EncodeConverter(){

            protected boolean isCompressRequested() {
                return false;
            }
        };
        String encodedString = converter.getAsEncodeString((Object)new StructureAndState(serializedView));
        StructureAndState decoded = (StructureAndState)converter.getAsDecodeObject(encodedString);
        AAA aaa = (AAA)decoded.getStructure();
        AAA bbb = (AAA)decoded.getState();
        Base64EncodeConverterTest.assertEquals((String)"aaaStructure", (String)aaa.getName());
        Base64EncodeConverterTest.assertEquals((String)"bbbState", (String)bbb.getName());
    }

    public void testEncodeAndDecode_Compressed() throws Exception {
        StateManager stateManager = this.getApplication().getStateManager();
        stateManager.getClass();
        StateManager.SerializedView serializedView = new StateManager.SerializedView(stateManager, (Object)new AAA("aaa"), (Object)new AAA("bbb"));
        Base64EncodeConverter converter = new Base64EncodeConverter(){

            protected boolean isCompressRequested() {
                return true;
            }
        };
        String encodedString = converter.getAsEncodeString((Object)new StructureAndState(serializedView));
        StructureAndState decoded = (StructureAndState)converter.getAsDecodeObject(encodedString);
        AAA aaa = (AAA)decoded.getStructure();
        AAA bbb = (AAA)decoded.getState();
        Base64EncodeConverterTest.assertEquals((String)"aaa", (String)aaa.getName());
        Base64EncodeConverterTest.assertEquals((String)"bbb", (String)bbb.getName());
    }

    public void testIsCompressRequested() throws Exception {
        FacesConfigOptions.setCompressState((boolean)true);
        Base64EncodeConverter converter = new Base64EncodeConverter();
        Base64EncodeConverterTest.assertTrue((boolean)converter.isCompressRequested());
        FacesConfigOptions.setCompressState((boolean)false);
        Base64EncodeConverterTest.assertFalse((boolean)converter.isCompressRequested());
    }

    public void testLearningGZIP() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipOut = new GZIPOutputStream(baos);
        gzipOut.write("12345".getBytes());
        gzipOut.finish();
        byte[] out = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(out);
        GZIPInputStream gzipIn = new GZIPInputStream(bais);
        byte[] read = InputStreamUtil.getBytes((InputStream)gzipIn);
        Base64EncodeConverterTest.assertEquals((String)"12345", (String)new String(read));
    }

    public static class AAA
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String name;

        public AAA(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

