/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.application;

import java.util.Date;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.IntegerConverter;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;
import javax.faces.validator.Validator;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.teeda.core.application.ApplicationImpl;
import org.seasar.teeda.core.application.ComponentLookupStrategy;
import org.seasar.teeda.core.application.ConverterConfiguration;
import org.seasar.teeda.core.application.impl.DefaultComponentLookupStrategy;
import org.seasar.teeda.core.el.ELParser;
import org.seasar.teeda.core.el.ExpressionProcessor;
import org.seasar.teeda.core.el.ValueBindingFactory;
import org.seasar.teeda.core.el.impl.ValueBindingFactoryImpl;
import org.seasar.teeda.core.el.impl.commons.CommonsELParser;
import org.seasar.teeda.core.el.impl.commons.CommonsExpressionProcessorImpl;
import org.seasar.teeda.core.exception.IllegalClassTypeException;
import org.seasar.teeda.core.mock.MockConverter;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockUIComponent;
import org.seasar.teeda.core.mock.MockValidatorWithProperties;
import org.seasar.teeda.core.mock.MockValueBinding;
import org.seasar.teeda.core.mock.MockVariableResolver;
import org.seasar.teeda.core.mock.NullValidator;
import org.seasar.teeda.core.unit.ExceptionAssert;
import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.core.util.DIContainerUtil;

public class ApplicationImplTest
extends TeedaTestCase {
    public void testAddComponent() {
        ApplicationImpl app = this.createApplication();
        MockUIComponent mock = new MockUIComponent();
        app.addComponent("mock", mock.getClass().getName());
        UIComponent c = app.createComponent("mock");
        ApplicationImplTest.assertNotNull((Object)c);
        ApplicationImplTest.assertTrue((boolean)(c instanceof MockUIComponent));
        try {
            app.addComponent("mock2", "java.lang.String");
            ApplicationImplTest.fail();
        }
        catch (IllegalClassTypeException e) {
            ApplicationImplTest.assertEquals((Object)UIComponent.class.getName(), (Object)e.getArgs()[0]);
            ApplicationImplTest.assertTrue((boolean)true);
        }
    }

    public void testCreateComponent1() {
        ApplicationImpl app = this.createApplication();
        MockUIComponent mock = new MockUIComponent();
        app.addComponent("mock", mock.getClass().getName());
        MockValueBinding vb = new MockValueBinding();
        MockFacesContext context = this.getFacesContext();
        vb.setValue((FacesContext)context, (Object)mock);
        UIComponent c = app.createComponent((ValueBinding)vb, (FacesContext)context, "mock");
        ApplicationImplTest.assertNotNull((Object)c);
        ApplicationImplTest.assertTrue((boolean)(c instanceof MockUIComponent));
    }

    public void testCreateComponent2() {
        ApplicationImpl app = this.createApplication();
        MockUIComponent mock = new MockUIComponent();
        app.addComponent("mock", mock.getClass().getName());
        MockValueBinding vb = new MockValueBinding();
        MockFacesContext context = this.getFacesContext();
        vb.setValue((FacesContext)context, (Object)"mock");
        UIComponent c = app.createComponent((ValueBinding)vb, (FacesContext)context, "mock");
        ApplicationImplTest.assertNotNull((Object)c);
        ApplicationImplTest.assertTrue((boolean)(c instanceof MockUIComponent));
    }

    public void testCreateConverter_ConverterIdIsNull() throws Exception {
        ApplicationImpl app = this.createApplication();
        String converterId = null;
        try {
            app.createConverter(converterId);
            ApplicationImplTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public void testCreateConverter_ConverterForClassIsNull() throws Exception {
        ApplicationImpl app = this.createApplication();
        Class converterForClass = null;
        try {
            app.createConverter(converterForClass);
            ApplicationImplTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public void testAddConverter1() {
        ApplicationImpl app = this.createApplication();
        app.addConverter("mock.converter", "org.seasar.teeda.core.mock.MockConverter");
        Converter c = app.createConverter("mock.converter");
        ApplicationImplTest.assertNotNull((Object)c);
        ApplicationImplTest.assertTrue((boolean)(c instanceof MockConverter));
    }

    public void testAddConverter2() {
        ApplicationImpl app = this.createApplication();
        app.addConverter(Hoge.class, "org.seasar.teeda.core.mock.MockConverter");
        Converter c = app.createConverter(Hoge.class);
        ApplicationImplTest.assertNotNull((Object)c);
        ApplicationImplTest.assertTrue((boolean)(c instanceof MockConverter));
    }

    public void testAddConverter_converterInstanciateEverytime() {
        ApplicationImpl app = this.createApplication();
        app.addConverter("aaa", HogeConverter2.class.getName());
        app.addConverter(Hoge.class, HogeConverter2.class.getName());
        Converter c = app.createConverter("aaa");
        ApplicationImplTest.assertNotNull((Object)c);
        ApplicationImplTest.assertTrue((boolean)(c instanceof HogeConverter2));
        HogeConverter2 c2 = (HogeConverter2)c;
        ApplicationImplTest.assertTrue((c2.getNum() == 1 ? 1 : 0) != 0);
        c = app.createConverter(Hoge.class);
        ApplicationImplTest.assertNotNull((Object)c);
        ApplicationImplTest.assertTrue((boolean)(c instanceof HogeConverter2));
        HogeConverter2 c3 = (HogeConverter2)c;
        ApplicationImplTest.assertTrue((c3.getNum() == 1 ? 1 : 0) != 0);
    }

    public void testCreateConverterForInterface() {
        ApplicationImpl app = this.createApplication();
        app.addConverter(Foo.class, "org.seasar.teeda.core.mock.MockConverter");
        FooImpl foo = new FooImpl();
        Converter c = app.createConverter(foo.getClass());
        ApplicationImplTest.assertNotNull((Object)c);
        ApplicationImplTest.assertTrue((boolean)(c instanceof MockConverter));
    }

    public void testCreateConverterForSuperClass() {
        ApplicationImpl app = this.createApplication();
        app.addConverter(Hoge.class, "org.seasar.teeda.core.mock.MockConverter");
        Hoge2 hoge = new Hoge2();
        Converter c = app.createConverter(hoge.getClass());
        ApplicationImplTest.assertNotNull((Object)c);
        ApplicationImplTest.assertTrue((boolean)(c instanceof MockConverter));
    }

    public void testCreateCoverterForPrimitive() {
        ApplicationImpl app = this.createApplication();
        Converter c = app.createConverter(Integer.TYPE);
        ApplicationImplTest.assertNotNull((Object)c);
        ApplicationImplTest.assertTrue((boolean)(c instanceof IntegerConverter));
    }

    public void testAddValidator1() {
        ApplicationImpl app = this.createApplication();
        app.addValidator("teeda.null", "org.seasar.teeda.core.mock.NullValidator");
        Validator v = app.createValidator("teeda.null");
        ApplicationImplTest.assertNotNull((Object)v);
        ApplicationImplTest.assertTrue((boolean)(v instanceof NullValidator));
        try {
            app.addValidator("hoge", "java.lang.String");
        }
        catch (IllegalClassTypeException e) {
            ApplicationImplTest.assertEquals((Object)Validator.class.getName(), (Object)e.getArgs()[0]);
            ApplicationImplTest.assertTrue((boolean)true);
        }
    }

    public void testCreateConverter_withProperties1() throws Exception {
        ApplicationImpl app = this.createApplication();
        ConverterConfiguration config = new ConverterConfiguration("pattern", "String", "yyyy/MM/dd HH:mm:ss");
        app.addConverterConfiguration("someConverterId", config);
        app.addConverter("someConverterId", HogeConverter.class.getName());
        Converter c = app.createConverter("someConverterId");
        ApplicationImplTest.assertNotNull((Object)c);
        ApplicationImplTest.assertTrue((boolean)(c instanceof HogeConverter));
        ApplicationImplTest.assertEquals((String)"yyyy/MM/dd HH:mm:ss", (String)((HogeConverter)c).getPattern());
    }

    public void testCreateConverter_withProperties2() throws Exception {
        ApplicationImpl app = this.createApplication();
        ConverterConfiguration config = new ConverterConfiguration("num", "int", "3");
        app.addConverterConfiguration("someConverterId", config);
        app.addConverter("someConverterId", HogeConverter.class.getName());
        Converter c = app.createConverter("someConverterId");
        ApplicationImplTest.assertNotNull((Object)c);
        ApplicationImplTest.assertTrue((boolean)(c instanceof HogeConverter));
        ApplicationImplTest.assertEquals((int)3, (int)((HogeConverter)c).getNum());
    }

    public void testGetWellKnownConverter() throws Exception {
        ApplicationImplTest.assertEquals((Object)IntegerConverter.class, ApplicationImpl.getWellKnownConverter(Integer.TYPE).getClass());
    }

    public void testCreateValueBinding() throws Exception {
        ValueBindingFactoryImpl ctx = new ValueBindingFactoryImpl();
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        ctx.setELParser((ELParser)parser);
        ApplicationImpl app = this.createApplication();
        app.setValueBindingFactory((ValueBindingFactory)ctx);
        MockVariableResolver resolver = this.getVariableResolver();
        A a = new A();
        a.setName("AAA");
        resolver.putValue("a", (Object)a);
        app.setVariableResolver((VariableResolver)resolver);
        ValueBinding vb = app.createValueBinding("#{a.name}");
        ApplicationImplTest.assertNotNull((Object)vb);
        ApplicationImplTest.assertEquals((String)"#{a.name}", (String)vb.getExpressionString());
        Object value = vb.getValue((FacesContext)this.getFacesContext());
        ApplicationImplTest.assertEquals((Object)"AAA", (Object)value);
    }

    public void testCreateValidator_registerToDIContainer() throws Exception {
        ComponentDefImpl cDef = new ComponentDefImpl(MockValidatorWithProperties.class);
        cDef.setComponentName("mock");
        PropertyDefImpl pDef = new PropertyDefImpl("name");
        pDef.setValue((Object)"hoge");
        cDef.addPropertyDef((PropertyDef)pDef);
        this.getContainer().register((ComponentDef)cDef);
        ApplicationImpl app = this.createApplication();
        Validator v = app.createValidator("mock");
        ApplicationImplTest.assertNotNull((Object)v);
        ApplicationImplTest.assertTrue((boolean)(v instanceof MockValidatorWithProperties));
        MockValidatorWithProperties mock = (MockValidatorWithProperties)v;
        ApplicationImplTest.assertEquals((String)"hoge", (String)mock.getName());
    }

    public void testCreateConverter_duplicateConverter1() throws Exception {
        ApplicationImpl app = this.createApplication();
        app.addConverter(((Object)((Object)this)).getClass(), A1Converter.class.getName());
        app.addConverter(((Object)((Object)this)).getClass(), A2Converter.class.getName());
        Converter c = app.createConverter(((Object)((Object)this)).getClass());
        ApplicationImplTest.assertNotNull((Object)c);
        ApplicationImplTest.assertTrue((boolean)(c instanceof A1Converter));
    }

    public void testCreateConverter_duplicateConverter2() throws Exception {
        ComponentDefImpl cDef = new ComponentDefImpl(A1Converter.class, Date.class.getName());
        this.getContainer().register((ComponentDef)cDef);
        ApplicationImpl app = this.createApplication();
        app.addConverter(((Object)((Object)this)).getClass(), A2Converter.class.getName());
        Converter c = app.createConverter(((Object)((Object)this)).getClass());
        ApplicationImplTest.assertNotNull((Object)c);
        ApplicationImplTest.assertTrue((boolean)(c instanceof A1Converter));
        DIContainerUtil.getComponent((Object)A1Converter.class);
    }

    public void testCreateComponent_orderTest() throws Exception {
        ComponentDefImpl cDef = new ComponentDefImpl(MockUIComponent.class, "mock");
        PropertyDefImpl pDef = new PropertyDefImpl("id");
        pDef.setValue((Object)"aaa");
        cDef.addPropertyDef((PropertyDef)pDef);
        this.getContainer().register((ComponentDef)cDef);
        ApplicationImpl app = this.createApplication();
        app.addComponent("mock", MockUIComponent.class.getName());
        UIComponent c = app.createComponent("mock");
        ApplicationImplTest.assertNotNull((Object)c);
        MockUIComponent mock = (MockUIComponent)c;
        ApplicationImplTest.assertEquals((String)"aaa", (String)mock.getId());
    }

    public ApplicationImpl createApplication() {
        ApplicationImpl app = new ApplicationImpl();
        app.setComponentLookupStrategy((ComponentLookupStrategy)new DefaultComponentLookupStrategy());
        return app;
    }

    public static class A2Converter
    extends A1Converter {
    }

    public static class A1Converter
    implements Converter {
        public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
            return null;
        }

        public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
            return null;
        }
    }

    public static class HogeConverter2
    implements Converter {
        public int num = 0;

        public HogeConverter2() {
            ++this.num;
        }

        public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
            return null;
        }

        public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
            return null;
        }

        public int getNum() {
            return this.num;
        }
    }

    public static class A {
        String name_ = "aaa";

        public String getName() {
            return this.name_;
        }

        public void setName(String name) {
            this.name_ = name;
        }
    }

    private static class FooImpl
    implements Foo {
        private FooImpl() {
        }
    }

    private static interface Foo {
    }

    private static class Hoge2
    extends Hoge {
        private Hoge2() {
        }
    }

    private static class Hoge {
        private Hoge() {
        }
    }

    public static class HogeConverter
    implements Converter {
        private String pattern_;
        private int num_;

        public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
            return null;
        }

        public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
            return null;
        }

        public void setPattern(String pattern) {
            this.pattern_ = pattern;
        }

        public String getPattern() {
            return this.pattern_;
        }

        public int getNum() {
            return this.num_;
        }

        public void setNum(int num) {
            this.num_ = num;
        }
    }
}

