/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import javax.faces.FacesException;
import javax.faces.model.ResultSetDataModel;
import junit.framework.TestCase;
import org.seasar.teeda.core.mock.NullResultSet;

public class ResultSetDataModelTest
extends TestCase {
    public void testResultSetDataModel_notUpdatable() throws Exception {
        NoScrollableResultSet resultSet = new NoScrollableResultSet();
        try {
            new ResultSetDataModel((ResultSet)resultSet);
            ResultSetDataModelTest.fail();
        }
        catch (IllegalArgumentException expected) {
            ResultSetDataModelTest.assertTrue((boolean)true);
        }
    }

    public void testGetRowCount_alwaysReturnMinus1() throws Exception {
        ResultSetDataModelTest.assertEquals((int)-1, (int)new ResultSetDataModel().getRowCount());
    }

    public void testGetRowData_resultSetNull() throws Exception {
        ResultSetDataModel model = new ResultSetDataModel();
        ResultSetDataModelTest.assertNull((Object)model.getRowData());
    }

    public void testGetRowData_indexNotInRange() throws Exception {
        ResultSetDataModel model = new ResultSetDataModel((ResultSet)new AbsoluteAlwaysFalseResultSet());
        model.setRowIndex(-1);
        try {
            model.getRowData();
            ResultSetDataModelTest.fail();
        }
        catch (IllegalArgumentException expected) {
            ResultSetDataModelTest.assertTrue((boolean)true);
        }
    }

    public void testGetRowData_normal() throws Exception {
        ResultSetDataModel model = new ResultSetDataModel((ResultSet)new NormalResultSet());
        ResultSetDataModelTest.assertTrue((boolean)(model.getRowData() instanceof AbstractMap));
    }

    public void testIsRowAvailable_resultSetIsNull() throws Exception {
        ResultSetDataModel model = new ResultSetDataModel();
        ResultSetDataModelTest.assertFalse((boolean)model.isRowAvailable());
    }

    public void testIsRowAvailable_indexLessThan0() throws Exception {
        ResultSetDataModel model = new ResultSetDataModel((ResultSet)new NormalResultSet());
        model.setRowIndex(-1);
        ResultSetDataModelTest.assertFalse((boolean)model.isRowAvailable());
    }

    public void testIsRowAvailable_throwSqlException() throws Exception {
        try {
            new ResultSetDataModel((ResultSet)new AbsoluteThrowExceptionResultSet());
            ResultSetDataModelTest.fail();
        }
        catch (FacesException expected) {
            ResultSetDataModelTest.assertTrue((boolean)true);
        }
    }

    private static class AbsoluteThrowExceptionResultSet
    extends NullResultSet {
        private AbsoluteThrowExceptionResultSet() {
        }

        public int getType() throws SQLException {
            return 1005;
        }

        public boolean absolute(int arg0) throws SQLException {
            throw new SQLException();
        }
    }

    private static class NormalResultSet
    extends NullResultSet {
        private NormalResultSet() {
        }

        public int getType() throws SQLException {
            return 1005;
        }

        public boolean absolute(int arg0) throws SQLException {
            return true;
        }
    }

    private static class AbsoluteAlwaysFalseResultSet
    extends NullResultSet {
        private AbsoluteAlwaysFalseResultSet() {
        }

        public int getType() throws SQLException {
            return 1005;
        }

        public boolean absolute(int arg0) throws SQLException {
            return false;
        }
    }

    private static class NoScrollableResultSet
    extends NullResultSet {
        private NoScrollableResultSet() {
        }

        public int getType() throws SQLException {
            return 1004;
        }
    }
}

