/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.ajax;

import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockHttpServletResponse;
import org.seasar.framework.mock.servlet.MockHttpServletResponseImpl;
import org.seasar.framework.unit.S2FrameworkTestCase;
import org.seasar.framework.util.SPrintWriter;
import org.seasar.teeda.ajax.AjaxBean1;
import org.seasar.teeda.ajax.AjaxBean4;
import org.seasar.teeda.ajax.AjaxServlet;

public class AjaxServletTest
extends S2FrameworkTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        super.include("ajaxTest.dicon");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public AjaxServletTest(String arg0) {
        super(arg0);
    }

    public void testGetComponent_NotFound() throws Exception {
        AjaxServlet servlet = new AjaxServlet();
        servlet.init((ServletConfig)this.getServletConfig());
        this.getRequest().addParameter("component", "Hoge");
        try {
            servlet.doGet((HttpServletRequest)this.getRequest(), (HttpServletResponse)this.getResponse());
            AjaxServletTest.fail();
        }
        catch (ServletException e) {
            AjaxServletTest.assertMessageExist((Exception)((Object)e));
        }
    }

    public void testGetComponent_NotPublicNoMeta() throws Exception {
        AjaxServlet servlet = new AjaxServlet();
        servlet.init((ServletConfig)this.getServletConfig());
        this.getRequest().addParameter("component", "ajaxBean2");
        try {
            servlet.doGet((HttpServletRequest)this.getRequest(), (HttpServletResponse)this.getResponse());
            AjaxServletTest.fail();
        }
        catch (ServletException e) {
            AjaxServletTest.assertMessageExist((Exception)((Object)e));
        }
    }

    public void testAjaxMethod_noMeta() throws Exception {
        AjaxServlet servlet = new AjaxServlet();
        servlet.init((ServletConfig)this.getServletConfig());
        this.getRequest().addParameter("component", "ajaxBean2");
        this.getRequest().addParameter("action", "ajaxHoge");
        servlet.doGet((HttpServletRequest)this.getRequest(), (HttpServletResponse)this.getResponse());
    }

    public void testGetComponent_NotPublicBadMeta() throws Exception {
        AjaxServlet servlet = new AjaxServlet();
        servlet.init((ServletConfig)this.getServletConfig());
        this.getRequest().addParameter("component", "ajaxBean3");
        try {
            servlet.doGet((HttpServletRequest)this.getRequest(), (HttpServletResponse)this.getResponse());
            AjaxServletTest.fail();
        }
        catch (ServletException e) {
            AjaxServletTest.assertMessageExist((Exception)((Object)e));
        }
    }

    public void testAction_Default() throws Exception {
        AjaxServlet servlet = new AjaxServlet();
        servlet.init((ServletConfig)this.getServletConfig());
        MockHttpServletRequest request = this.getRequest();
        request.addParameter("component", "ajaxBean1");
        try {
            servlet.doGet((HttpServletRequest)request, (HttpServletResponse)this.getResponse());
            AjaxServletTest.fail();
        }
        catch (ServletException e) {
            AjaxServletTest.assertMessageExist((Exception)((Object)e));
        }
    }

    public void testAction_BadMethodName() throws Exception {
        AjaxServlet servlet = new AjaxServlet();
        servlet.init((ServletConfig)this.getServletConfig());
        MockHttpServletRequest request = this.getRequest();
        request.addParameter("component", "ajaxBean1");
        request.addParameter("action", "hoge");
        try {
            servlet.doGet((HttpServletRequest)request, (HttpServletResponse)this.getResponse());
            AjaxServletTest.fail();
        }
        catch (ServletException e) {
            AjaxServletTest.assertMessageExist((Exception)((Object)e));
        }
    }

    public void testSetParameter_ArgString() throws Exception {
        AjaxServlet servlet = new AjaxServlet();
        servlet.init((ServletConfig)this.getServletConfig());
        MockHttpServletRequest request = this.getRequest();
        request.addParameter("component", "ajaxBean1");
        request.addParameter("action", "ajaxHoge");
        String ARG1 = "ABCDEFG";
        request.addParameter("arg1", "ABCDEFG");
        request.addParameter("arg2", "2");
        MockSPrintWriter writer = new MockSPrintWriter();
        MyMockHttpServletResponseImpl response = new MyMockHttpServletResponseImpl((HttpServletRequest)this.getRequest());
        response.setWriter((PrintWriter)((Object)writer));
        servlet.doGet((HttpServletRequest)request, (HttpServletResponse)response);
        AjaxServletTest.assertEquals((String)"{arg1:\"ABCDEFG\",arg2:2}", (String)writer.getResult());
        AjaxServletTest.assertEquals((String)"ABCDEFG", (String)((AjaxBean1)this.getComponent("ajaxBean1")).getArg1());
    }

    public void testSetParameter_ArgInteger() throws Exception {
        AjaxServlet servlet = new AjaxServlet();
        servlet.init((ServletConfig)this.getServletConfig());
        MockHttpServletRequest request = this.getRequest();
        request.addParameter("component", "ajaxBean1");
        request.addParameter("action", "ajaxHoge");
        String ARG2 = "22222";
        request.addParameter("arg2", "22222");
        MockSPrintWriter writer = new MockSPrintWriter();
        MyMockHttpServletResponseImpl response = new MyMockHttpServletResponseImpl((HttpServletRequest)this.getRequest());
        response.setWriter((PrintWriter)((Object)writer));
        servlet.doGet((HttpServletRequest)request, (HttpServletResponse)response);
        Integer arg2 = new Integer("22222");
        AjaxServletTest.assertEquals((String)"{arg1:null,arg2:22222}", (String)writer.getResult());
        AjaxServletTest.assertEquals((int)arg2, (int)((AjaxBean1)this.getComponent("ajaxBean1")).getArg2());
    }

    public void testDefaultResponseCotentType() throws Exception {
        AjaxServlet servlet = new AjaxServlet();
        servlet.init((ServletConfig)this.getServletConfig());
        MockHttpServletRequest request = this.getRequest();
        MockHttpServletResponse response = this.getResponse();
        request.addParameter("component", "ajaxBean1");
        request.addParameter("action", "ajaxHoge");
        servlet.doGet((HttpServletRequest)request, (HttpServletResponse)response);
        AjaxServletTest.assertEquals((String)"text/javascript; charset=UTF-8", (String)response.getContentType());
    }

    public void testArgs_isNull() throws Exception {
        AjaxServlet servlet = new AjaxServlet();
        servlet.init((ServletConfig)this.getServletConfig());
        MockHttpServletRequest request = this.getRequest();
        request.addParameter("component", "ajaxBean1");
        request.addParameter("action", "ajaxFoo");
        try {
            servlet.doGet((HttpServletRequest)request, (HttpServletResponse)this.getResponse());
            AjaxServletTest.fail();
        }
        catch (ServletException e) {
            AjaxServletTest.assertMessageExist((Exception)((Object)e));
        }
    }

    public void testArgs_BadArgType() throws Exception {
        AjaxServlet servlet = new AjaxServlet();
        servlet.init((ServletConfig)this.getServletConfig());
        MockHttpServletRequest request = this.getRequest();
        request.addParameter("component", "ajaxBean1");
        request.addParameter("action", "ajaxFoo");
        request.addParameter("AjaxParam0", "aaa");
        request.addParameter("AjaxParam1", "6");
        try {
            servlet.doGet((HttpServletRequest)request, (HttpServletResponse)this.getResponse());
            AjaxServletTest.fail();
        }
        catch (ServletException e) {
            AjaxServletTest.assertMessageExist((Exception)((Object)e));
        }
    }

    public void testArgs_BadArgc() throws Exception {
        AjaxServlet servlet = new AjaxServlet();
        servlet.init((ServletConfig)this.getServletConfig());
        MockHttpServletRequest request = this.getRequest();
        request.addParameter("component", "ajaxBean1");
        request.addParameter("action", "ajaxFoo");
        request.addParameter("AjaxParam0", "4");
        request.addParameter("AjaxParam1", "abc");
        request.addParameter("AjaxParam2", "def");
        try {
            servlet.doGet((HttpServletRequest)request, (HttpServletResponse)this.getResponse());
            AjaxServletTest.fail();
        }
        catch (ServletException e) {
            AjaxServletTest.assertMessageExist((Exception)((Object)e));
        }
    }

    public void testArgs_BadArgvOrder() throws Exception {
        AjaxServlet servlet = new AjaxServlet();
        servlet.init((ServletConfig)this.getServletConfig());
        MockHttpServletRequest request = this.getRequest();
        request.addParameter("component", "ajaxBean1");
        request.addParameter("action", "ajaxFoo");
        request.addParameter("AjaxParam1", "4");
        request.addParameter("AjaxParam0", "abc");
        try {
            servlet.doGet((HttpServletRequest)request, (HttpServletResponse)this.getResponse());
            AjaxServletTest.fail();
        }
        catch (ServletException e) {
            AjaxServletTest.assertMessageExist((Exception)((Object)e));
        }
    }

    public void testSetParameter_ArgIntegerNull() throws Exception {
        AjaxServlet servlet = new AjaxServlet();
        servlet.init((ServletConfig)this.getServletConfig());
        MockHttpServletRequest request = this.getRequest();
        request.addParameter("component", "ajaxBean4");
        request.addParameter("action", "ajaxTest");
        String EMPTY_STRING = "";
        request.addParameter("argNum", "");
        request.addParameter("arg1", "");
        MockSPrintWriter writer = new MockSPrintWriter();
        MyMockHttpServletResponseImpl response = new MyMockHttpServletResponseImpl((HttpServletRequest)this.getRequest());
        response.setWriter((PrintWriter)((Object)writer));
        servlet.doGet((HttpServletRequest)request, (HttpServletResponse)response);
        AjaxServletTest.assertEquals((String)"{arg1:0,argNum:null}", (String)writer.getResult());
        AjaxServletTest.assertEquals(null, (Object)((AjaxBean4)this.getComponent("ajaxBean4")).getArgNum());
    }

    public void testArgs_InvokeSuccess() throws Exception {
        AjaxServlet servlet = new AjaxServlet();
        servlet.init((ServletConfig)this.getServletConfig());
        MockHttpServletRequest request = this.getRequest();
        MockSPrintWriter writer = new MockSPrintWriter();
        MyMockHttpServletResponseImpl response = new MyMockHttpServletResponseImpl((HttpServletRequest)this.getRequest());
        response.setWriter((PrintWriter)((Object)writer));
        request.addParameter("component", "ajaxBean1");
        request.addParameter("action", "ajaxFoo");
        request.addParameter("AjaxParam0", "1");
        request.addParameter("AjaxParam1", "abc");
        servlet.doGet((HttpServletRequest)request, (HttpServletResponse)response);
        AjaxServletTest.assertEquals((String)"{arg1:null,arg2:0}", (String)writer.getResult());
    }

    private static void assertMessageExist(Exception e) {
        String message = e.getMessage();
        System.out.println(message);
        AjaxServletTest.assertNotNull((Object)message);
        AjaxServletTest.assertTrue((message.trim().length() > 0 ? 1 : 0) != 0);
    }

    private static class MockSPrintWriter
    extends SPrintWriter {
        private String result = null;

        private MockSPrintWriter() {
        }

        public String getResult() {
            return this.result;
        }

        public void close() {
            this.result = this.out.toString();
            super.close();
        }
    }

    private static class MyMockHttpServletResponseImpl
    extends MockHttpServletResponseImpl {
        private PrintWriter writer = new SPrintWriter();

        public MyMockHttpServletResponseImpl(HttpServletRequest request) {
            super(request);
        }

        public PrintWriter getWriter() {
            return this.writer;
        }

        public void setWriter(PrintWriter writer) {
            this.writer = writer;
        }
    }
}

