/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import javax.faces.component.UIComponent;
import junit.framework.TestCase;
import org.seasar.teeda.core.mock.MockUIComponentBase;
import org.seasar.teeda.core.util.RenderedComponentIterator;

public class RenderedComponentIteratorTest
extends TestCase {
    public void testOne() throws Exception {
        MockUIComponentBase component = new MockUIComponentBase();
        MockUIComponentBase child = new MockUIComponentBase();
        child.setRendered(true);
        component.getChildren().add(child);
        RenderedComponentIterator it = new RenderedComponentIterator((Collection)component.getChildren());
        RenderedComponentIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        it.next();
        RenderedComponentIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testOne_RenderFalse() throws Exception {
        MockUIComponentBase component = new MockUIComponentBase();
        MockUIComponentBase child = new MockUIComponentBase();
        child.setRendered(false);
        component.getChildren().add(child);
        RenderedComponentIterator it = new RenderedComponentIterator((Collection)component.getChildren());
        RenderedComponentIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testMany() throws Exception {
        MockUIComponentBase component = new MockUIComponentBase();
        MockUIComponentBase child = new MockUIComponentBase();
        child.setId("a");
        child.setRendered(false);
        component.getChildren().add(child);
        child = new MockUIComponentBase();
        child.setId("b");
        child.setRendered(true);
        component.getChildren().add(child);
        child = new MockUIComponentBase();
        child.setId("c");
        child.setRendered(true);
        component.getChildren().add(child);
        child = new MockUIComponentBase();
        child.setId("d");
        child.setRendered(false);
        component.getChildren().add(child);
        RenderedComponentIterator it = new RenderedComponentIterator((Collection)component.getChildren());
        UIComponent child2 = (UIComponent)it.next();
        RenderedComponentIteratorTest.assertEquals((String)"b", (String)child2.getId());
        child2 = (UIComponent)it.next();
        RenderedComponentIteratorTest.assertEquals((String)"c", (String)child2.getId());
        try {
            it.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testEmpty_HasNext() throws Exception {
        RenderedComponentIterator it = new RenderedComponentIterator(new ArrayList());
        RenderedComponentIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testEmpty_Next() throws Exception {
        RenderedComponentIterator it = new RenderedComponentIterator(new ArrayList());
        try {
            it.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

