/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.el.impl.commons;

import javax.faces.context.FacesContext;
import javax.faces.el.VariableResolver;
import org.seasar.teeda.core.el.ExpressionProcessor;
import org.seasar.teeda.core.el.TeedaVariableResolver;
import org.seasar.teeda.core.el.impl.commons.CommonsELParser;
import org.seasar.teeda.core.el.impl.commons.CommonsExpressionProcessorImpl;
import org.seasar.teeda.core.mock.MockApplication;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class CommonsELParserTest
extends TeedaTestCase {
    public void testParse_Boolean() {
        this.getContainer().register((Object)new Foo(), "foo");
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        Object o = parser.parse("#{foo.aaa != null && foo.aaa == true}");
        MockApplication app = this.getApplication();
        TeedaVariableResolver resolver = new TeedaVariableResolver();
        resolver.setContainer(this.getContainer());
        app.setVariableResolver((VariableResolver)resolver);
        Object obj = parser.getExpressionProcessor().evaluate((FacesContext)this.getFacesContext(), o);
        CommonsELParserTest.assertEquals((Object)Boolean.FALSE, (Object)obj);
    }

    public void testParse_Boolean2() {
        Foo foo = new Foo();
        foo.setAaa(Boolean.TRUE);
        this.getContainer().register((Object)foo, "foo");
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        Object o = parser.parse("#{foo.aaa != null && foo.aaa == true}");
        MockApplication app = this.getApplication();
        TeedaVariableResolver resolver = new TeedaVariableResolver();
        resolver.setContainer(this.getContainer());
        app.setVariableResolver((VariableResolver)resolver);
        Object obj = parser.getExpressionProcessor().evaluate((FacesContext)this.getFacesContext(), o);
        CommonsELParserTest.assertEquals((Object)Boolean.TRUE, (Object)obj);
    }

    public void testParse_Boolean3() {
        Bar foo = new Bar();
        foo.setAaa(Boolean.TRUE);
        this.getContainer().register((Object)foo, "foo");
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        Object o = parser.parse("#{foo.aaa == true}");
        MockApplication app = this.getApplication();
        TeedaVariableResolver resolver = new TeedaVariableResolver();
        resolver.setContainer(this.getContainer());
        app.setVariableResolver((VariableResolver)resolver);
        Object obj = parser.getExpressionProcessor().evaluate((FacesContext)this.getFacesContext(), o);
        CommonsELParserTest.assertEquals((Object)Boolean.TRUE, (Object)obj);
    }

    public void testParse() {
        this.getContainer().register((Object)new Hoge(), "hoge");
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        Object o = parser.parse("#{hoge.name}");
        MockApplication app = this.getApplication();
        TeedaVariableResolver resolver = new TeedaVariableResolver();
        resolver.setContainer(this.getContainer());
        app.setVariableResolver((VariableResolver)resolver);
        Object obj = parser.getExpressionProcessor().evaluate((FacesContext)this.getFacesContext(), o);
        CommonsELParserTest.assertEquals((Object)"foo", (Object)obj);
    }

    public void testParse_complex() {
        this.getContainer().register((Object)new Hoge(), "hoge");
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        Object o = parser.parse("func(#{hoge.name}, #{hoge.bar})");
        MockApplication app = this.getApplication();
        TeedaVariableResolver resolver = new TeedaVariableResolver();
        resolver.setContainer(this.getContainer());
        app.setVariableResolver((VariableResolver)resolver);
        Object obj = parser.getExpressionProcessor().evaluate((FacesContext)this.getFacesContext(), o);
        CommonsELParserTest.assertEquals((Object)"func(foo, bar)", (Object)obj);
    }

    public void testParse_noParse() {
        this.getContainer().register((Object)new Hoge(), "hoge");
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        Object o = parser.parse("''#{hoge.name}'', ''#{hoge.bar}''");
        MockApplication app = this.getApplication();
        TeedaVariableResolver resolver = new TeedaVariableResolver();
        resolver.setContainer(this.getContainer());
        app.setVariableResolver((VariableResolver)resolver);
        Object obj = parser.getExpressionProcessor().evaluate((FacesContext)this.getFacesContext(), o);
        CommonsELParserTest.assertEquals((Object)"''foo'', ''bar''", (Object)obj);
    }

    public void testNullHandle() throws Exception {
        CommonsELParser parser = new CommonsELParser();
        CommonsExpressionProcessorImpl processor = new CommonsExpressionProcessorImpl();
        parser.setExpressionProcessor((ExpressionProcessor)processor);
        Object o = parser.parse("#{hoge == null}");
        CommonsELParserTest.assertNotNull((Object)o);
        Boolean b = (Boolean)processor.evaluate((FacesContext)this.getFacesContext(), o);
        CommonsELParserTest.assertTrue((boolean)b);
    }

    public static class Bar {
        private Boolean aaa = null;

        public Boolean isAaa() {
            return this.aaa;
        }

        public void setAaa(Boolean aaa) {
            this.aaa = aaa;
        }
    }

    public static class Foo {
        private Boolean aaa = null;

        public Boolean getAaa() {
            return this.aaa;
        }

        public void setAaa(Boolean aaa) {
            this.aaa = aaa;
        }
    }

    public static class Hoge {
        private String name = "foo";
        private String bar = "bar";

        public String getName() {
            return this.name;
        }

        public String getBar() {
            return this.bar;
        }
    }
}

