/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.scope.impl;

import org.seasar.teeda.core.scope.Scope;
import org.seasar.teeda.core.scope.impl.ScopeManagerImpl;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class ScopeManagerImplTest
extends TeedaTestCase {
    public void testGetScope() {
        ScopeManagerImpl manager = new ScopeManagerImpl();
        ScopeManagerImplTest.assertEquals((Object)Scope.APPLICATION, (Object)manager.getScope(Scope.APPLICATION.getScopeKey()));
        ScopeManagerImplTest.assertEquals((Object)Scope.SESSION, (Object)manager.getScope(Scope.SESSION.getScopeKey()));
        ScopeManagerImplTest.assertEquals((Object)Scope.REQUEST, (Object)manager.getScope(Scope.REQUEST.getScopeKey()));
        ScopeManagerImplTest.assertEquals((Object)Scope.NONE, (Object)manager.getScope(Scope.NONE.getScopeKey()));
        HogeScope hoge = new HogeScope();
        manager.addScope((Scope)hoge, (Object)"aaa");
        ScopeManagerImplTest.assertEquals((Object)hoge, (Object)manager.getScope(hoge.getScopeKey()));
    }

    public void testIsDefaultScope() {
        ScopeManagerImpl manager = new ScopeManagerImpl();
        ScopeManagerImplTest.assertTrue((boolean)manager.isDefaultScope(Scope.APPLICATION));
        ScopeManagerImplTest.assertTrue((boolean)manager.isDefaultScope(Scope.SESSION));
        ScopeManagerImplTest.assertTrue((boolean)manager.isDefaultScope(Scope.REQUEST));
        ScopeManagerImplTest.assertTrue((boolean)manager.isDefaultScope(Scope.NONE));
        ScopeManagerImplTest.assertFalse((boolean)manager.isDefaultScope(new Scope(){

            public String getScopeKey() {
                return "aaa";
            }
        }));
    }

    private static class HogeScope
    implements Scope {
        private HogeScope() {
        }

        public String getScopeKey() {
            return "hoge";
        }
    }
}

