/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import junitx.framework.ObjectAssert;
import org.custommonkey.xmlunit.Diff;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockHtmlCommandButton;
import org.seasar.teeda.core.mock.MockMethodBinding;
import org.seasar.teeda.core.mock.MockUIComponentBaseWithNamingContainer;
import org.seasar.teeda.core.render.html.HtmlCommandButtonRenderer;

public class HtmlCommandButtonRendererTest
extends RendererTest {
    private HtmlCommandButtonRenderer renderer;
    private MockHtmlCommandButton htmlCommandButton;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlCommandButtonRenderer();
        this.htmlCommandButton = new MockHtmlCommandButton();
        this.htmlCommandButton.setRenderer((Renderer)this.renderer);
    }

    public void testEncode_NoValue() throws Exception {
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandButton);
        HtmlCommandButtonRendererTest.assertEquals((String)"<input type=\"submit\" name=\"_id0\" />", (String)this.getResponseText());
    }

    public void testEncode_WithValue() throws Exception {
        this.htmlCommandButton.setValue("abc");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandButton);
        HtmlCommandButtonRendererTest.assertEquals((String)"<input type=\"submit\" name=\"_id0\" value=\"abc\" />", (String)this.getResponseText());
    }

    public void testEncode_WithValue2() throws Exception {
        this.htmlCommandButton.setValue("&nbsp;abc");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandButton);
        HtmlCommandButtonRendererTest.assertEquals((String)"<input type=\"submit\" name=\"_id0\" value=\"&nbsp;abc\" />", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlCommandButton.setRendered(false);
        this.htmlCommandButton.setValue("abc");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandButton);
        HtmlCommandButtonRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_WithId() throws Exception {
        this.htmlCommandButton.setId("a");
        MockUIComponentBaseWithNamingContainer parent = new MockUIComponentBaseWithNamingContainer();
        parent.setId("b");
        parent.getChildren().add(this.htmlCommandButton);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandButton);
        HtmlCommandButtonRendererTest.assertEquals((String)"<input type=\"submit\" id=\"a\" name=\"b:a\" />", (String)this.getResponseText());
    }

    public void testEncode_Reset() throws Exception {
        this.htmlCommandButton.setId("a");
        this.htmlCommandButton.setType("reset");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandButton);
        HtmlCommandButtonRendererTest.assertEquals((String)"<input type=\"reset\" id=\"a\" name=\"a\" />", (String)this.getResponseText());
    }

    public void testEncode_Image() throws Exception {
        this.htmlCommandButton.setId("a");
        this.htmlCommandButton.setImage("bb");
        this.htmlCommandButton.setValue("c");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandButton);
        HtmlCommandButtonRendererTest.assertEquals((String)"<input type=\"image\" id=\"a\" name=\"a\" src=\"bb\" />", (String)this.getResponseText());
    }

    public void testEncode_ImageIfTypeIsReset() throws Exception {
        this.htmlCommandButton.setId("a");
        this.htmlCommandButton.setType("reset");
        this.htmlCommandButton.setImage("bb");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandButton);
        HtmlCommandButtonRendererTest.assertEquals((String)"<input type=\"image\" id=\"a\" name=\"a\" src=\"bb\" />", (String)this.getResponseText());
    }

    public void testEncode_IgnoreAttributes() throws Exception {
        this.htmlCommandButton.setId("a");
        this.htmlCommandButton.setAction((MethodBinding)new MockMethodBinding());
        this.htmlCommandButton.setImmediate(true);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandButton);
        HtmlCommandButtonRendererTest.assertEquals((String)"<input type=\"submit\" id=\"a\" name=\"a\" />", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute1() throws Exception {
        this.htmlCommandButton.setId("a");
        this.htmlCommandButton.getAttributes().put("b", "c");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandButton);
        HtmlCommandButtonRendererTest.assertEquals((String)"<input type=\"submit\" id=\"a\" name=\"a\" b=\"c\" />", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute2() throws Exception {
        this.htmlCommandButton.setId("a");
        this.htmlCommandButton.getAttributes().put("b.c", "c");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandButton);
        HtmlCommandButtonRendererTest.assertEquals((String)"<input type=\"submit\" id=\"a\" name=\"a\" />", (String)this.getResponseText());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        this.htmlCommandButton.setAccesskey("a");
        this.htmlCommandButton.setAlt("b");
        this.htmlCommandButton.setDir("c");
        this.htmlCommandButton.setDisabled(true);
        this.htmlCommandButton.setLang("f");
        this.htmlCommandButton.setOnblur("g");
        this.htmlCommandButton.setOnchange("h");
        this.htmlCommandButton.setOnclick("i");
        this.htmlCommandButton.setOndblclick("j");
        this.htmlCommandButton.setOnfocus("k");
        this.htmlCommandButton.setOnkeydown("l");
        this.htmlCommandButton.setOnkeypress("m");
        this.htmlCommandButton.setOnkeyup("n");
        this.htmlCommandButton.setOnmousedown("o");
        this.htmlCommandButton.setOnmousemove("p");
        this.htmlCommandButton.setOnmouseout("q");
        this.htmlCommandButton.setOnmouseover("r");
        this.htmlCommandButton.setOnmouseup("s");
        this.htmlCommandButton.setOnselect("t");
        this.htmlCommandButton.setReadonly(true);
        this.htmlCommandButton.setStyle("w");
        this.htmlCommandButton.setStyleClass("u");
        this.htmlCommandButton.setTabindex("x");
        this.htmlCommandButton.setTitle("y");
        this.htmlCommandButton.setType("reset");
        this.htmlCommandButton.setId("A");
        this.htmlCommandButton.setValue("B");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlCommandButton);
        Diff diff = new Diff("<input type=\"reset\" id=\"A\" name=\"A\" value=\"B\" accesskey=\"a\" alt=\"b\" dir=\"c\" disabled=\"disabled\" lang=\"f\" onblur=\"g\" onchange=\"h\" onclick=\"i\" ondblclick=\"j\" onfocus=\"k\" onkeydown=\"l\" onkeypress=\"m\" onkeyup=\"n\" onmousedown=\"o\" onmousemove=\"p\" onmouseout=\"q\" onmouseover=\"r\" onmouseup=\"s\" onselect=\"t\" readonly=\"readonly\" style=\"w\" class=\"u\" tabindex=\"x\" title=\"y\"/>", this.getResponseText());
        HtmlCommandButtonRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testDecode_None() throws Exception {
        final FacesEvent[] args = new FacesEvent[]{null};
        MockHtmlCommandButton htmlCommandButton = new MockHtmlCommandButton(){

            public void queueEvent(FacesEvent event) {
                args[0] = event;
            }
        };
        htmlCommandButton.setRenderer((Renderer)this.renderer);
        htmlCommandButton.setClientId("key");
        MockFacesContext context = this.getFacesContext();
        this.renderer.decode((FacesContext)context, (UIComponent)htmlCommandButton);
        HtmlCommandButtonRendererTest.assertEquals(null, (Object)args[0]);
    }

    public void testDecode_None_ResetType() throws Exception {
        final FacesEvent[] args = new FacesEvent[]{null};
        MockHtmlCommandButton htmlCommandButton = new MockHtmlCommandButton(){

            public void queueEvent(FacesEvent event) {
                args[0] = event;
            }
        };
        htmlCommandButton.setRenderer((Renderer)this.renderer);
        htmlCommandButton.setType("reset");
        htmlCommandButton.setClientId("key");
        MockFacesContext context = this.getFacesContext();
        context.getExternalContext().getRequestParameterMap().put("key", "12345");
        this.renderer.decode((FacesContext)context, (UIComponent)htmlCommandButton);
        HtmlCommandButtonRendererTest.assertEquals(null, (Object)args[0]);
    }

    public void testDecode_SubmitSuccess() throws Exception {
        this.submitSuccessTest("key:aa");
    }

    public void testDecode_SubmitSuccessX() throws Exception {
        this.submitSuccessTest("key:aa.x");
    }

    public void testDecode_SubmitSuccessY() throws Exception {
        this.submitSuccessTest("key:aa.y");
    }

    private void submitSuccessTest(String requestKey) {
        final FacesEvent[] args = new FacesEvent[]{null};
        MockHtmlCommandButton htmlCommandButton = new MockHtmlCommandButton(){

            public void queueEvent(FacesEvent event) {
                args[0] = event;
            }
        };
        htmlCommandButton.setRenderer((Renderer)this.renderer);
        htmlCommandButton.setClientId("key:aa");
        MockFacesContext context = this.getFacesContext();
        context.getExternalContext().getRequestParameterMap().put(requestKey, "12345");
        this.renderer.decode((FacesContext)context, (UIComponent)htmlCommandButton);
        HtmlCommandButtonRendererTest.assertNotNull((String)requestKey, (Object)args[0]);
        ObjectAssert.assertInstanceOf((String)requestKey, (Class)ActionEvent.class, (Object)args[0]);
        HtmlCommandButtonRendererTest.assertSame((String)requestKey, (Object)((Object)htmlCommandButton), (Object)args[0].getSource());
    }

    public void testGetRendersChildren() throws Exception {
        HtmlCommandButtonRendererTest.assertEquals((boolean)false, (boolean)this.renderer.getRendersChildren());
    }

    private HtmlCommandButtonRenderer createHtmlCommandButtonRenderer() {
        return (HtmlCommandButtonRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlCommandButtonRenderer renderer = new HtmlCommandButtonRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }
}

