/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render;

import java.util.HashMap;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import junit.framework.TestCase;
import org.seasar.teeda.core.exception.NoEditableValueHolderRuntimeException;
import org.seasar.teeda.core.mock.MockUIComponentBaseWithEditableValueHolder;
import org.seasar.teeda.core.mock.NullExternalContext;
import org.seasar.teeda.core.mock.NullFacesContext;
import org.seasar.teeda.core.mock.NullUIComponent;
import org.seasar.teeda.core.render.DefaultDecoder;
import org.seasar.teeda.core.unit.ExceptionAssert;

public class DefaultDecoderTest
extends TestCase {
    public void testDecode_Success() throws Exception {
        MockUIComponentBaseWithEditableValueHolder component = new MockUIComponentBaseWithEditableValueHolder();
        component.setClientId("foo");
        final HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        NullFacesContext context = new NullFacesContext(){

            public ExternalContext getExternalContext() {
                return new NullExternalContext(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Map getRequestParameterMap() {
                        return 1.access$000(this.this$1);
                    }
                };
            }

            static /* synthetic */ Map access$000(1 x0) {
                return x0.map;
            }
        };
        DefaultDecoder decoder = new DefaultDecoder();
        decoder.decode((FacesContext)context, (UIComponent)component);
        DefaultDecoderTest.assertEquals((Object)"bar", (Object)((EditableValueHolder)component).getSubmittedValue());
    }

    public void testDecode_None() throws Exception {
        MockUIComponentBaseWithEditableValueHolder component = new MockUIComponentBaseWithEditableValueHolder();
        component.setClientId("foo");
        final HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo1", "bar");
        NullFacesContext context = new NullFacesContext(){

            public ExternalContext getExternalContext() {
                return new NullExternalContext(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Map getRequestParameterMap() {
                        return 3.access$100(this.this$1);
                    }
                };
            }

            static /* synthetic */ Map access$100(3 x0) {
                return x0.map;
            }
        };
        DefaultDecoder decoder = new DefaultDecoder();
        decoder.decode((FacesContext)context, (UIComponent)component);
        DefaultDecoderTest.assertEquals(null, (Object)((EditableValueHolder)component).getSubmittedValue());
    }

    public void testDecode_WithNullContext() throws Exception {
        try {
            DefaultDecoder decoder = new DefaultDecoder();
            decoder.decode(null, (UIComponent)new MockUIComponentBaseWithEditableValueHolder());
            DefaultDecoderTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public void testDecode_WithNullComponent() throws Exception {
        try {
            DefaultDecoder decoder = new DefaultDecoder();
            decoder.decode((FacesContext)new NullFacesContext(), null);
            DefaultDecoderTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public void testDecode_WithNoEditableValueHolder() throws Exception {
        try {
            DefaultDecoder decoder = new DefaultDecoder();
            decoder.decode((FacesContext)new NullFacesContext(), (UIComponent)new NullUIComponent());
            DefaultDecoderTest.fail();
        }
        catch (NoEditableValueHolderRuntimeException expected) {
            ExceptionAssert.assertMessageExist(expected);
        }
    }

    public void testDecodeMany_WithNullContext() throws Exception {
        try {
            DefaultDecoder decoder = new DefaultDecoder();
            decoder.decodeMany(null, (UIComponent)new MockUIComponentBaseWithEditableValueHolder());
            DefaultDecoderTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public void testDecodeMany_WithNullComponent() throws Exception {
        try {
            DefaultDecoder decoder = new DefaultDecoder();
            decoder.decodeMany((FacesContext)new NullFacesContext(), null);
            DefaultDecoderTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public void testDecodeMany_WithNoEditableValueHolder() throws Exception {
        try {
            DefaultDecoder decoder = new DefaultDecoder();
            decoder.decodeMany((FacesContext)new NullFacesContext(), (UIComponent)new NullUIComponent());
            DefaultDecoderTest.fail();
        }
        catch (NoEditableValueHolderRuntimeException expected) {
            ExceptionAssert.assertMessageExist(expected);
        }
    }
}

