/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContextFactory;
import javax.faces.internal.FactoryFinderUtil;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKitFactory;
import junitx.framework.ObjectAssert;
import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.teeda.core.config.faces.assembler.AssembleProvider;
import org.seasar.teeda.core.config.faces.assembler.AssemblerAssembler;
import org.seasar.teeda.core.config.faces.assembler.impl.DefaultAssembleProvider;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.faces.impl.MetaInfFacesConfigurator;
import org.seasar.teeda.core.mock.MockApplicationFactory;
import org.seasar.teeda.core.mock.MockFacesContextFactory;
import org.seasar.teeda.core.mock.MockLifecycleFactory;
import org.seasar.teeda.core.mock.MockRenderKitFactory;

public class MetaInfFacesConfiguratorTest
extends S2TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConfigure1() throws Exception {
        File buildDir = ResourceUtil.getBuildDir(((Object)((Object)this)).getClass());
        File jarDir = new File(buildDir, ((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/'));
        File[] jars = jarDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        MetaInfFacesConfiguratorTest.assertEquals((int)1, (int)jars.length);
        URL[] jarUrls = new URL[jars.length];
        for (int i = 0; i < jars.length; ++i) {
            System.out.println(jars[i].toURL());
            jarUrls[i] = jars[i].toURL();
        }
        ClassLoader orgCl = Thread.currentThread().getContextClassLoader();
        URLClassLoader cl = new URLClassLoader(jarUrls, orgCl);
        try {
            Thread.currentThread().setContextClassLoader(cl);
            String path = ((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/');
            MetaInfFacesConfigurator configurator = new MetaInfFacesConfigurator();
            configurator.setPath(path);
            FacesConfig facesConfig = configurator.configure();
            MetaInfFacesConfiguratorTest.assertNotNull((Object)facesConfig);
            AssemblerAssembler assembler = new AssemblerAssembler();
            DefaultAssembleProvider provider = new DefaultAssembleProvider();
            assembler.setAssembleProvider((AssembleProvider)provider);
            assembler.assembleFactories(facesConfig);
            ApplicationFactory appFactory = FactoryFinderUtil.getApplicationFactory();
            ObjectAssert.assertInstanceOf((Class)MockApplicationFactory.class, (Object)appFactory);
            LifecycleFactory lifecycleFactory = FactoryFinderUtil.getLifecycleFactory();
            ObjectAssert.assertInstanceOf((Class)MockLifecycleFactory.class, (Object)lifecycleFactory);
            FacesContextFactory contextFactory = FactoryFinderUtil.getFacesContextFactory();
            ObjectAssert.assertInstanceOf((Class)MockFacesContextFactory.class, (Object)contextFactory);
            RenderKitFactory renderKitFactory = FactoryFinderUtil.getRenderKitFactory();
            ObjectAssert.assertInstanceOf((Class)MockRenderKitFactory.class, (Object)renderKitFactory);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orgCl);
        }
    }
}

