/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.impl;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.event.PhaseListener;
import javax.faces.internal.FactoryFinderUtil;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import junitx.framework.ObjectAssert;
import org.seasar.extension.unit.S2TestCase;
import org.seasar.teeda.core.application.navigation.NavigationCaseContext;
import org.seasar.teeda.core.application.navigation.NavigationContext;
import org.seasar.teeda.core.application.navigation.NavigationResource;
import org.seasar.teeda.core.config.faces.assembler.AssembleProvider;
import org.seasar.teeda.core.config.faces.assembler.AssemblerAssembler;
import org.seasar.teeda.core.config.faces.assembler.impl.DefaultAssembleProvider;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.faces.impl.CoreFacesConfigurator;
import org.seasar.teeda.core.config.faces.impl.Hoge;
import org.seasar.teeda.core.managedbean.ManagedBeanFactory;
import org.seasar.teeda.core.managedbean.impl.ManagedBeanFactoryImpl;
import org.seasar.teeda.core.managedbean.impl.ManagedBeanScopeSaverImpl;
import org.seasar.teeda.core.mock.MockActionListener;
import org.seasar.teeda.core.mock.MockApplication;
import org.seasar.teeda.core.mock.MockApplicationFactory;
import org.seasar.teeda.core.mock.MockFacesContextFactory;
import org.seasar.teeda.core.mock.MockLifecycle;
import org.seasar.teeda.core.mock.MockLifecycleFactory;
import org.seasar.teeda.core.mock.MockNavigationHandler;
import org.seasar.teeda.core.mock.MockPhaseListener;
import org.seasar.teeda.core.mock.MockPropertyResolver;
import org.seasar.teeda.core.mock.MockRenderKitFactory;
import org.seasar.teeda.core.mock.MockRenderKitImpl;
import org.seasar.teeda.core.mock.MockRenderer;
import org.seasar.teeda.core.mock.MockStateManager;
import org.seasar.teeda.core.mock.MockVariableResolver;
import org.seasar.teeda.core.mock.MockViewHandlerImpl;
import org.seasar.teeda.core.scope.Scope;
import org.seasar.teeda.core.scope.impl.S2ScopeTranslator;
import org.seasar.teeda.core.scope.impl.ScopeManagerImpl;

public class CoreFacesConfiguratorTest
extends S2TestCase {
    public CoreFacesConfiguratorTest(String name) {
        super(name);
    }

    public void testConfigure1() throws Exception {
        CoreFacesConfigurator configurator = new CoreFacesConfigurator();
        configurator.setPath(((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/') + "/CoreFacesConfiguratorTest-testConfigure1.xml");
        FacesConfig facesConfig = configurator.configure();
        CoreFacesConfiguratorTest.assertNotNull((Object)facesConfig);
        AssemblerAssembler assembler = new AssemblerAssembler();
        DefaultAssembleProvider provider = new DefaultAssembleProvider();
        assembler.setAssembleProvider((AssembleProvider)provider);
        assembler.assembleFactories(facesConfig);
        ApplicationFactory appFactory = FactoryFinderUtil.getApplicationFactory();
        ObjectAssert.assertInstanceOf((Class)MockApplicationFactory.class, (Object)appFactory);
        LifecycleFactory lifecycleFactory = FactoryFinderUtil.getLifecycleFactory();
        ObjectAssert.assertInstanceOf((Class)MockLifecycleFactory.class, (Object)lifecycleFactory);
        FacesContextFactory contextFactory = FactoryFinderUtil.getFacesContextFactory();
        ObjectAssert.assertInstanceOf((Class)MockFacesContextFactory.class, (Object)contextFactory);
        RenderKitFactory renderKitFactory = FactoryFinderUtil.getRenderKitFactory();
        ObjectAssert.assertInstanceOf((Class)MockRenderKitFactory.class, (Object)renderKitFactory);
        assembler.assembleApplication(facesConfig);
        Application app = appFactory.getApplication();
        CoreFacesConfiguratorTest.assertNotNull((Object)app);
        ObjectAssert.assertInstanceOf((Class)MockApplication.class, (Object)app);
        ObjectAssert.assertInstanceOf((Class)MockActionListener.class, (Object)app.getActionListener());
        ObjectAssert.assertInstanceOf((Class)MockStateManager.class, (Object)app.getStateManager());
        ObjectAssert.assertInstanceOf((Class)MockNavigationHandler.class, (Object)app.getNavigationHandler());
        ObjectAssert.assertInstanceOf((Class)MockPropertyResolver.class, (Object)app.getPropertyResolver());
        ObjectAssert.assertInstanceOf((Class)MockVariableResolver.class, (Object)app.getVariableResolver());
        ObjectAssert.assertInstanceOf((Class)MockViewHandlerImpl.class, (Object)app.getViewHandler());
        CoreFacesConfiguratorTest.assertEquals((Object)Locale.JAPANESE, (Object)app.getDefaultLocale());
        CoreFacesConfiguratorTest.assertEquals((Object)Locale.ENGLISH, app.getSupportedLocales().next());
        CoreFacesConfiguratorTest.assertEquals((String)"hoge", (String)app.getDefaultRenderKitId());
        CoreFacesConfiguratorTest.assertEquals((String)"message", (String)app.getMessageBundle());
        assembler.assembleLifecycle(facesConfig);
        Lifecycle lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
        CoreFacesConfiguratorTest.assertNotNull((Object)lifecycle);
        ObjectAssert.assertInstanceOf((Class)MockLifecycle.class, (Object)lifecycle);
        PhaseListener[] listeners = lifecycle.getPhaseListeners();
        CoreFacesConfiguratorTest.assertEquals((int)1, (int)listeners.length);
        ObjectAssert.assertInstanceOf((Class)MockPhaseListener.class, (Object)listeners[0]);
        this.getContainer().register(ManagedBeanFactoryImpl.class);
        this.getContainer().register(ManagedBeanScopeSaverImpl.class);
        this.getContainer().register(ScopeManagerImpl.class);
        this.getContainer().register(S2ScopeTranslator.class);
        assembler.assembleManagedBeans(facesConfig);
        ManagedBeanFactory mbFactory = (ManagedBeanFactory)this.getContainer().getComponent((Object)ManagedBeanFactory.class);
        Object o = mbFactory.getManagedBean("hogeBean");
        CoreFacesConfiguratorTest.assertNotNull((Object)o);
        ObjectAssert.assertInstanceOf((Class)Hoge.class, (Object)o);
        Scope scope = mbFactory.getManagedBeanScope("hogeBean");
        CoreFacesConfiguratorTest.assertEquals((Object)Scope.APPLICATION, (Object)scope);
        assembler.assembleRenderKits(facesConfig);
        FacesContext context = contextFactory.getFacesContext((Object)this.getServletContext(), (Object)this.getRequest(), (Object)this.getResponse(), lifecycle);
        RenderKit renderKit = renderKitFactory.getRenderKit(context, "renderkitid");
        CoreFacesConfiguratorTest.assertNotNull((Object)renderKit);
        ObjectAssert.assertInstanceOf((Class)MockRenderKitImpl.class, (Object)renderKit);
        Renderer renderer = renderKit.getRenderer("family", "type");
        CoreFacesConfiguratorTest.assertNotNull((Object)renderer);
        ObjectAssert.assertInstanceOf((Class)MockRenderer.class, (Object)renderer);
        assembler.assmbleNavigationRules(facesConfig);
        Map map = NavigationResource.getNavigationContexts();
        List list = (List)map.get("from");
        NavigationContext navContext = (NavigationContext)list.get(0);
        CoreFacesConfiguratorTest.assertEquals((String)"from", (String)navContext.getFromViewId());
        List cases = navContext.getNavigationCases();
        CoreFacesConfiguratorTest.assertNotNull((Object)cases);
        CoreFacesConfiguratorTest.assertEquals((int)1, (int)cases.size());
        NavigationCaseContext caseContext = (NavigationCaseContext)cases.get(0);
        CoreFacesConfiguratorTest.assertEquals((String)"action", (String)caseContext.getFromAction());
        CoreFacesConfiguratorTest.assertEquals((String)"outcome", (String)caseContext.getFromOutcome());
        CoreFacesConfiguratorTest.assertEquals((String)"to", (String)caseContext.getToViewId());
    }
}

