/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.assembler.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.seasar.teeda.core.application.navigation.NavigationCaseContext;
import org.seasar.teeda.core.application.navigation.NavigationContext;
import org.seasar.teeda.core.application.navigation.NavigationResource;
import org.seasar.teeda.core.config.faces.assembler.impl.DefaultNavigationRuleAssembler;
import org.seasar.teeda.core.config.faces.element.NavigationCaseElement;
import org.seasar.teeda.core.config.faces.element.NavigationRuleElement;
import org.seasar.teeda.core.config.faces.element.impl.NavigationCaseElementImpl;
import org.seasar.teeda.core.config.faces.element.impl.NavigationRuleElementImpl;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class DefaultNavigationRuleAssemblerTest
extends TeedaTestCase {
    public void testSetupChildAssembler() throws Exception {
        ArrayList<NavigationRuleElementImpl> list = new ArrayList<NavigationRuleElementImpl>();
        NavigationRuleElementImpl rule = new NavigationRuleElementImpl();
        list.add(rule);
        DefaultNavigationRuleAssembler assembler = new DefaultNavigationRuleAssembler(list);
        assembler.setupBeforeAssemble();
    }

    public void testAssemble() throws Exception {
        NavigationRuleElementImpl rule = new NavigationRuleElementImpl();
        rule.setFromViewId("aaa");
        NavigationCaseElementImpl caseElement = new NavigationCaseElementImpl();
        caseElement.setFromAction("bbb");
        caseElement.setFromOutcome("ccc");
        caseElement.setRedirect("");
        caseElement.setToViewId("ddd");
        rule.addNavigationCase((NavigationCaseElement)caseElement);
        ArrayList<NavigationRuleElementImpl> list = new ArrayList<NavigationRuleElementImpl>();
        list.add(rule);
        DefaultNavigationRuleAssembler assembler = new DefaultNavigationRuleAssembler(list);
        assembler.assemble();
        Map map = NavigationResource.getNavigationContexts();
        DefaultNavigationRuleAssemblerTest.assertTrue((boolean)map.containsKey("aaa"));
        List l = (List)map.get("aaa");
        NavigationContext navContext = (NavigationContext)l.get(0);
        DefaultNavigationRuleAssemblerTest.assertEquals((String)"aaa", (String)navContext.getFromViewId());
        DefaultNavigationRuleAssemblerTest.assertFalse((boolean)navContext.isWildCardMatch());
        List cases = navContext.getNavigationCases();
        DefaultNavigationRuleAssemblerTest.assertEquals((int)1, (int)cases.size());
        NavigationCaseContext caseContext = (NavigationCaseContext)cases.get(0);
        DefaultNavigationRuleAssemblerTest.assertEquals((String)"bbb", (String)caseContext.getFromAction());
        DefaultNavigationRuleAssemblerTest.assertEquals((String)"ccc", (String)caseContext.getFromOutcome());
        DefaultNavigationRuleAssemblerTest.assertEquals((String)"ddd", (String)caseContext.getToViewId());
        DefaultNavigationRuleAssemblerTest.assertTrue((boolean)caseContext.isRedirect());
    }

    public void testAssemble_noViewId() throws Exception {
        NavigationRuleElementImpl rule = new NavigationRuleElementImpl();
        NavigationCaseElementImpl caseElement = new NavigationCaseElementImpl();
        caseElement.setFromAction("b");
        caseElement.setFromOutcome("c");
        caseElement.setRedirect("");
        caseElement.setToViewId("d");
        rule.addNavigationCase((NavigationCaseElement)caseElement);
        ArrayList<NavigationRuleElementImpl> list = new ArrayList<NavigationRuleElementImpl>();
        list.add(rule);
        DefaultNavigationRuleAssembler assembler = new DefaultNavigationRuleAssembler(list);
        assembler.assemble();
        Map map = NavigationResource.getDefaultMatchNavigationContexts();
        DefaultNavigationRuleAssemblerTest.assertTrue((boolean)map.containsKey("*"));
        List l = (List)map.get("*");
        NavigationContext navContext = (NavigationContext)l.get(0);
        DefaultNavigationRuleAssemblerTest.assertEquals((String)"*", (String)navContext.getFromViewId());
        DefaultNavigationRuleAssemblerTest.assertTrue((boolean)navContext.isWildCardMatch());
        List cases = navContext.getNavigationCases();
        DefaultNavigationRuleAssemblerTest.assertEquals((int)1, (int)cases.size());
        NavigationCaseContext caseContext = (NavigationCaseContext)cases.get(0);
        DefaultNavigationRuleAssemblerTest.assertEquals((String)"b", (String)caseContext.getFromAction());
        DefaultNavigationRuleAssemblerTest.assertEquals((String)"c", (String)caseContext.getFromOutcome());
        DefaultNavigationRuleAssemblerTest.assertEquals((String)"d", (String)caseContext.getToViewId());
        DefaultNavigationRuleAssemblerTest.assertTrue((boolean)caseContext.isRedirect());
    }

    public void testNavigationContextWrapper() throws Exception {
        NavigationRuleElementImpl rule = new NavigationRuleElementImpl();
        rule.setFromViewId("aaa*");
        NavigationCaseElementImpl element = new NavigationCaseElementImpl();
        element.setFromAction("outcome");
        rule.addNavigationCase((NavigationCaseElement)element);
        DefaultNavigationRuleAssembler.NavigationContextWrapper wrapper = new DefaultNavigationRuleAssembler.NavigationContextWrapper((NavigationRuleElement)rule);
        DefaultNavigationRuleAssemblerTest.assertEquals((String)"aaa*", (String)wrapper.getFromViewId());
        DefaultNavigationRuleAssemblerTest.assertTrue((boolean)wrapper.isWildCardMatch());
        DefaultNavigationRuleAssemblerTest.assertEquals((int)1, (int)wrapper.getNavigationCases().size());
    }

    public void testNavigationCaseContextWrapper() throws Exception {
        NavigationCaseElementImpl element = new NavigationCaseElementImpl();
        element.setFromAction("action");
        element.setFromOutcome("outcome");
        DefaultNavigationRuleAssembler.NavigationCaseContextWrapper wrapper = new DefaultNavigationRuleAssembler.NavigationCaseContextWrapper((NavigationCaseElement)element);
        DefaultNavigationRuleAssemblerTest.assertEquals((String)"action", (String)wrapper.getFromAction());
        DefaultNavigationRuleAssemblerTest.assertEquals((String)"outcome", (String)wrapper.getFromOutcome());
    }
}

