/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import javax.faces.model.ScalarDataModel;
import junit.framework.TestCase;

public class ScalarDataModelTest
extends TestCase {
    public void testIsRowAvailable_succeed() throws Exception {
        ScalarDataModel model = new ScalarDataModel();
        model.setWrappedData(new Object());
        model.setRowIndex(0);
        ScalarDataModelTest.assertTrue((boolean)model.isRowAvailable());
    }

    public void testIsRowAvailable_wrappedDataUnavailable() throws Exception {
        ScalarDataModel model = new ScalarDataModel();
        model.setRowIndex(0);
        ScalarDataModelTest.assertFalse((boolean)model.isRowAvailable());
    }

    public void testIsRowAvailable_wrappedDataNull() throws Exception {
        ScalarDataModel model = new ScalarDataModel();
        model.setWrappedData(null);
        ScalarDataModelTest.assertFalse((boolean)model.isRowAvailable());
    }

    public void testGetRowCount_wrappedDataAvailable() throws Exception {
        ScalarDataModel model = new ScalarDataModel();
        model.setWrappedData(new Object());
        ScalarDataModelTest.assertEquals((int)1, (int)model.getRowCount());
    }

    public void testGetRowCount_wrappedDataUnavailable() throws Exception {
        ScalarDataModel model = new ScalarDataModel();
        model.setWrappedData(null);
        ScalarDataModelTest.assertEquals((int)-1, (int)model.getRowCount());
    }

    public void testGetRowData_succeed() throws Exception {
        ScalarDataModel model = new ScalarDataModel();
        model.setWrappedData((Object)"a");
        ScalarDataModelTest.assertEquals((Object)"a", (Object)model.getRowData());
    }

    public void testGetRowData_null() throws Exception {
        ScalarDataModel model = new ScalarDataModel();
        ScalarDataModelTest.assertNull((Object)model.getRowData());
    }

    public void testGetRowData_illegalStateRowData() throws Exception {
        ScalarDataModel model = new ScalarDataModel();
        model.setWrappedData(new Object());
        model.setRowIndex(1);
        try {
            model.getRowData();
            ScalarDataModelTest.fail();
        }
        catch (IllegalArgumentException expected) {
            ScalarDataModelTest.assertTrue((boolean)true);
        }
    }

    public void testGetRowIndex_getCurrentRow() throws Exception {
        ScalarDataModel model = new ScalarDataModel();
        model.setWrappedData((Object)"b");
        ScalarDataModelTest.assertEquals((int)0, (int)model.getRowIndex());
    }

    public void testGetRowIndex_noWrappedData() throws Exception {
        ScalarDataModel model = new ScalarDataModel();
        ScalarDataModelTest.assertEquals((int)-1, (int)model.getRowIndex());
    }

    public void testSetWrappedData_detached() throws Exception {
        ScalarDataModel model = new ScalarDataModel();
        model.setWrappedData(null);
        ScalarDataModelTest.assertEquals((int)-1, (int)model.getRowIndex());
    }

    public void testSetWrappedData_currentIndexZero() throws Exception {
        ScalarDataModel model = new ScalarDataModel();
        model.setWrappedData(new Object());
        ScalarDataModelTest.assertEquals((int)0, (int)model.getRowIndex());
    }
}

