/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.Iterator;
import java.util.Locale;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.internal.FacesMessageUtil;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockUIComponent;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class FacesMessageUtilTest
extends TeedaTestCase {
    public void testGetMesssages() throws Exception {
        MockFacesContext context = this.getFacesContext();
        context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, "a1", "a2"));
        context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "b1", "b2"));
        context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "c1", "c2"));
        context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_FATAL, "d1", "d2"));
        FacesMessage[] ems = FacesMessageUtil.getWarnMessages();
        FacesMessageUtilTest.assertNotNull((Object)ems);
        FacesMessageUtilTest.assertTrue((ems.length == 1 ? 1 : 0) != 0);
        FacesMessageUtilTest.assertEquals((String)"a1", (String)ems[0].getSummary());
        ems = FacesMessageUtil.getInfoMessages();
        FacesMessageUtilTest.assertNotNull((Object)ems);
        FacesMessageUtilTest.assertTrue((ems.length == 1 ? 1 : 0) != 0);
        FacesMessageUtilTest.assertEquals((String)"b1", (String)ems[0].getSummary());
        ems = FacesMessageUtil.getErrorMessages();
        FacesMessageUtilTest.assertNotNull((Object)ems);
        FacesMessageUtilTest.assertTrue((ems.length == 1 ? 1 : 0) != 0);
        FacesMessageUtilTest.assertEquals((String)"c1", (String)ems[0].getSummary());
        ems = FacesMessageUtil.getFatalMessages();
        FacesMessageUtilTest.assertNotNull((Object)ems);
        FacesMessageUtilTest.assertTrue((ems.length == 1 ? 1 : 0) != 0);
        FacesMessageUtilTest.assertEquals((String)"d1", (String)ems[0].getSummary());
    }

    public void testGetAllMesssages() throws Exception {
        MockFacesContext context = this.getFacesContext();
        context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, "a1", "a2"));
        context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "b1", "b2"));
        context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "c1", "c2"));
        context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_FATAL, "d1", "d2"));
        FacesMessage[] ems = FacesMessageUtil.getAllMessages();
        FacesMessageUtilTest.assertTrue((ems.length == 4 ? 1 : 0) != 0);
    }

    public void testGetSimpleErrorMessage() {
        this.getApplication().setMessageBundle("javax.faces.component.TestMessages");
        MockFacesContext context = this.getFacesContext();
        MockUIComponent component = new MockUIComponent();
        component.setClientId("a");
        UIViewRoot root = new UIViewRoot();
        root.setLocale(Locale.ENGLISH);
        context.setViewRoot(root);
        FacesMessageUtil.addErrorComponentMessage((FacesContext)context, (UIComponent)component, (String)"aaa");
        FacesMessageUtilTest.assertNotNull((Object)context.getMessages("a"));
        Iterator itr = context.getMessages();
        FacesMessage message = (FacesMessage)itr.next();
        FacesMessageUtilTest.assertEquals((String)"AAA", (String)message.getSummary());
    }

    public void testGetParameterizedMessage() {
        this.getApplication().setMessageBundle("javax.faces.component.TestMessages");
        MockFacesContext context = this.getFacesContext();
        MockUIComponent component = new MockUIComponent();
        component.setClientId("b");
        UIViewRoot root = new UIViewRoot();
        root.setLocale(Locale.ENGLISH);
        context.setViewRoot(root);
        FacesMessageUtil.addErrorComponentMessage((FacesContext)context, (UIComponent)component, (String)"bbb", (Object[])new Object[]{"B1", "B2"});
        FacesMessageUtilTest.assertNotNull((Object)context.getMessages("b"));
        Iterator itr = context.getMessages();
        FacesMessage message = (FacesMessage)itr.next();
        FacesMessageUtilTest.assertEquals((String)"B1,B2", (String)message.getSummary());
        FacesMessageUtilTest.assertEquals((String)"B1,B2 detail", (String)message.getDetail());
    }

    public void testGetParameterizedMessage_escapeNeed() {
        this.getApplication().setMessageBundle("javax.faces.component.TestMessages");
        MockFacesContext context = this.getFacesContext();
        MockUIComponent component = new MockUIComponent();
        component.setClientId("b");
        UIViewRoot root = new UIViewRoot();
        root.setLocale(Locale.ENGLISH);
        context.setViewRoot(root);
        FacesMessageUtil.addErrorComponentMessage((FacesContext)context, (UIComponent)component, (String)"bbb", (Object[])new Object[]{"<script>&", "</script>"});
        FacesMessageUtilTest.assertNotNull((Object)context.getMessages("b"));
        Iterator itr = context.getMessages();
        FacesMessage message = (FacesMessage)itr.next();
        FacesMessageUtilTest.assertEquals((String)"&lt;script&gt;&amp;,&lt;/script&gt;", (String)message.getSummary());
        FacesMessageUtilTest.assertEquals((String)"&lt;script&gt;&amp;,&lt;/script&gt; detail", (String)message.getDetail());
    }

    public void testApplicationResourceBundleMissing() {
        this.getApplication().setMessageBundle("javax.faces.component.NoFoundMessages");
        MockFacesContext context = this.getFacesContext();
        MockUIComponent component = new MockUIComponent();
        component.setClientId("c");
        UIViewRoot root = new UIViewRoot();
        root.setLocale(Locale.US);
        context.setViewRoot(root);
        FacesMessageUtil.addErrorComponentMessage((FacesContext)context, (UIComponent)component, (String)"javax.faces.component.UIInput.CONVERSION");
        FacesMessageUtilTest.assertNotNull((Object)context.getMessages("c"));
        Iterator itr = context.getMessages();
        FacesMessage message = (FacesMessage)itr.next();
        FacesMessageUtilTest.assertNotNull((Object)message.getSummary());
    }

    public void testApplicationResourceAndDefaultResource() {
        this.getApplication().setMessageBundle("javax.faces.component.TestMessages");
        MockFacesContext context = this.getFacesContext();
        MockUIComponent component = new MockUIComponent();
        component.setClientId("c");
        UIViewRoot root = new UIViewRoot();
        root.setLocale(Locale.US);
        context.setViewRoot(root);
        FacesMessageUtil.addErrorComponentMessage((FacesContext)context, (UIComponent)component, (String)"javax.faces.component.UIInput.CONVERSION");
        FacesMessageUtilTest.assertNotNull((Object)context.getMessages("c"));
        Iterator itr = context.getMessages();
        FacesMessage message = (FacesMessage)itr.next();
        FacesMessageUtilTest.assertNotNull((Object)message.getSummary());
    }

    public void testGetTargetFacesMessages_simplyGet() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, "aaa", null);
        context.addMessage(null, facesMessage);
        FacesMessage[] targetFacesMessages = FacesMessageUtil.getTargetFacesMessages((FacesContext)context, (FacesMessage.Severity[])new FacesMessage.Severity[]{FacesMessage.SEVERITY_ERROR});
        FacesMessageUtilTest.assertNotNull((Object)targetFacesMessages);
        FacesMessageUtilTest.assertTrue((targetFacesMessages.length == 1 ? 1 : 0) != 0);
        FacesMessageUtilTest.assertEquals((String)"aaa", (String)targetFacesMessages[0].getSummary());
    }

    public void testGetTargetFacesMessages_noMessages() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage[] targetFacesMessages = FacesMessageUtil.getTargetFacesMessages((FacesContext)context, (FacesMessage.Severity[])new FacesMessage.Severity[]{FacesMessage.SEVERITY_ERROR});
        FacesMessageUtilTest.assertNotNull((Object)targetFacesMessages);
        FacesMessageUtilTest.assertTrue((targetFacesMessages.length == 0 ? 1 : 0) != 0);
    }

    public void testGetTargetFacesMessages_messagesExistButNotMatch() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, "aaa", null);
        context.addMessage(null, facesMessage);
        FacesMessage[] targetFacesMessages = FacesMessageUtil.getTargetFacesMessages((FacesContext)context, (FacesMessage.Severity[])new FacesMessage.Severity[]{FacesMessage.SEVERITY_INFO});
        FacesMessageUtilTest.assertNotNull((Object)targetFacesMessages);
        FacesMessageUtilTest.assertTrue((targetFacesMessages.length == 0 ? 1 : 0) != 0);
    }

    public void testGetTargetFacesMessages_getMessages() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, "aaa", null);
        context.addMessage(null, facesMessage);
        facesMessage = new FacesMessage(FacesMessage.SEVERITY_FATAL, "bbb", null);
        context.addMessage(null, facesMessage);
        FacesMessage[] targetFacesMessages = FacesMessageUtil.getTargetFacesMessages((FacesContext)context, (FacesMessage.Severity[])new FacesMessage.Severity[]{FacesMessage.SEVERITY_ERROR, FacesMessage.SEVERITY_FATAL});
        FacesMessageUtilTest.assertNotNull((Object)targetFacesMessages);
        FacesMessageUtilTest.assertTrue((targetFacesMessages.length == 2 ? 1 : 0) != 0);
        FacesMessageUtilTest.assertEquals((String)"aaa", (String)targetFacesMessages[0].getSummary());
        FacesMessageUtilTest.assertEquals((String)"bbb", (String)targetFacesMessages[1].getSummary());
    }

    public void testHasMessages_noMessage() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessageUtilTest.assertFalse((boolean)FacesMessageUtil.hasMessages((FacesContext)context));
    }

    public void testHasMessages_hasMessage() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, "aaa", null);
        context.addMessage(null, facesMessage);
        FacesMessageUtilTest.assertTrue((boolean)FacesMessageUtil.hasMessages((FacesContext)context));
    }

    public void testHasMessagesByClientId_hasMessage() throws Exception {
        MockFacesContext context = this.getFacesContext();
        FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, "aaa", null);
        context.addMessage("hoge", facesMessage);
        MockUIComponent c = new MockUIComponent(){

            public String getClientId(FacesContext context) {
                return "hoge";
            }
        };
        FacesMessageUtilTest.assertTrue((boolean)FacesMessageUtil.hasMessagesByClientId((FacesContext)context, (UIComponent)c));
    }

    public void testHasErrorOrFatalMesssages1() throws Exception {
        MockFacesContext context = this.getFacesContext();
        context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, "c1", "c2"));
        FacesMessageUtilTest.assertTrue((boolean)FacesMessageUtil.hasErrorOrFatalMessage((FacesContext)context));
    }

    public void testHasErrorOrFatalMesssages2() throws Exception {
        MockFacesContext context = this.getFacesContext();
        context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_FATAL, "c1", "c2"));
        FacesMessageUtilTest.assertTrue((boolean)FacesMessageUtil.hasErrorOrFatalMessage((FacesContext)context));
    }

    public void testHasErrorOrFatalMesssages3() throws Exception {
        MockFacesContext context = this.getFacesContext();
        context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "c1", "c2"));
        FacesMessageUtilTest.assertFalse((boolean)FacesMessageUtil.hasErrorOrFatalMessage((FacesContext)context));
    }
}

