/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.AbstractConverterTestCase;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.ShortConverter;
import org.seasar.teeda.core.mock.MockUIComponent;

public class ShortConverterTest
extends AbstractConverterTestCase {
    public void testConstants() throws Exception {
        ShortConverterTest.assertEquals((String)"javax.faces.Short", (String)"javax.faces.Short");
    }

    public void testGetValueAsObject_convertSuccess() throws Exception {
        Converter converter = this.createConverter();
        Object o = converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), "2");
        ShortConverterTest.assertNotNull((Object)o);
        Short s = (Short)o;
        ShortConverterTest.assertTrue((s.intValue() == 2 ? 1 : 0) != 0);
    }

    public void testGetValueAsObject_convertFail() throws Exception {
        Converter converter = this.createConverter();
        try {
            converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), "32768");
            ShortConverterTest.fail();
        }
        catch (ConverterException expected) {
            ShortConverterTest.success();
        }
    }

    public void testGetValueAsString_convertSuccess() throws Exception {
        Converter converter = this.createConverter();
        String str = converter.getAsString((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), (Object)new Short(2));
        ShortConverterTest.assertEquals((String)"2", (String)str);
    }

    public void testGetValueAsString_convertFail() throws Exception {
        Converter converter = this.createConverter();
        try {
            converter.getAsString((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), (Object)new Integer(32768));
            ShortConverterTest.fail();
        }
        catch (ConverterException expected) {
            ShortConverterTest.success();
        }
    }

    public void testGetValueAsObject_convertWithDelimeter() throws Exception {
        Converter converter = this.createConverter();
        String value = "32,767";
        this.getFacesContext().getViewRoot().setLocale(Locale.JAPAN);
        Object o = converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), value);
        ShortConverterTest.assertNotNull((Object)o);
        Short s = (Short)o;
        ShortConverterTest.assertTrue((s.intValue() == Short.MAX_VALUE ? 1 : 0) != 0);
    }

    protected Converter createConverter() {
        return this.createShortConverter();
    }

    protected ShortConverter createShortConverter() {
        return new ShortConverter();
    }
}

