/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.util.Stack;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBaseTeedaTest;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.seasar.teeda.core.mock.MockFacesEvent;
import org.seasar.teeda.core.mock.NullUIComponent;

public class UIViewRootTeedaTest
extends UIComponentBaseTeedaTest {
    public void testQueueEvent_withAnyPhase() throws Exception {
        UIViewRoot root = this.createUIViewRoot();
        BroadcastStackUIComponent component = new BroadcastStackUIComponent();
        MockFacesEvent event = new MockFacesEvent((UIComponent)component);
        event.setPhaseId(PhaseId.ANY_PHASE);
        root.queueEvent((FacesEvent)event);
        root.broadcastEvents((FacesContext)this.getFacesContext(), PhaseId.APPLY_REQUEST_VALUES);
        Object o = component.getBroadcastedFacesEvent().pop();
        UIViewRootTeedaTest.assertNotNull(o);
        UIViewRootTeedaTest.assertTrue((boolean)(o instanceof MockFacesEvent));
        UIViewRootTeedaTest.assertEquals((Object)event, o);
    }

    public void testQueueEvent_withOneSelectedPhase() throws Exception {
        UIViewRoot root = this.createUIViewRoot();
        BroadcastStackUIComponent component = new BroadcastStackUIComponent();
        MockFacesEvent event = new MockFacesEvent((UIComponent)component);
        event.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
        root.queueEvent((FacesEvent)event);
        root.broadcastEvents((FacesContext)this.getFacesContext(), PhaseId.PROCESS_VALIDATIONS);
        Object o = component.getBroadcastedFacesEvent().pop();
        UIViewRootTeedaTest.assertNotNull(o);
        UIViewRootTeedaTest.assertTrue((boolean)(o instanceof MockFacesEvent));
        UIViewRootTeedaTest.assertEquals((Object)event, o);
    }

    public void testQueueEvent_abort() throws Exception {
        UIViewRoot root = this.createUIViewRoot();
        AbortUIComponent component1 = new AbortUIComponent();
        MockFacesEvent event1 = new MockFacesEvent((UIComponent)component1);
        BroadcastStackUIComponent component2 = new BroadcastStackUIComponent();
        MockFacesEvent event2 = new MockFacesEvent((UIComponent)component2);
        event1.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
        root.queueEvent((FacesEvent)event1);
        root.queueEvent((FacesEvent)event2);
        root.broadcastEvents((FacesContext)this.getFacesContext(), PhaseId.PROCESS_VALIDATIONS);
        UIViewRootTeedaTest.assertEquals((int)0, (int)root.getEventSize());
    }

    public void testSaveAndRestoreState() throws Exception {
        super.testSaveAndRestoreState();
        this.createUIViewRoot();
    }

    private UIViewRoot createUIViewRoot() {
        return (UIViewRoot)this.createUIComponent();
    }

    protected UIComponent createUIComponent() {
        return new UIViewRoot();
    }

    private static class AbortUIComponent
    extends NullUIComponent {
        private AbortUIComponent() {
        }

        public void broadcast(FacesEvent event) throws AbortProcessingException {
            throw new AbortProcessingException();
        }
    }

    private static class BroadcastStackUIComponent
    extends NullUIComponent {
        Stack stack = new Stack();

        private BroadcastStackUIComponent() {
        }

        public void broadcast(FacesEvent event) throws AbortProcessingException {
            this.stack.push(event);
        }

        public Stack getBroadcastedFacesEvent() {
            return this.stack;
        }
    }
}

