/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.AbstractUIComponentTest;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.internal.AttachedObjectStateWrapper;
import junitx.framework.ObjectAssert;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockFacesContextImpl;
import org.seasar.teeda.core.mock.MockUIComponent;
import org.seasar.teeda.core.mock.MockUIComponentBase;
import org.seasar.teeda.core.mock.MockValueBinding;
import org.seasar.teeda.core.mock.NullFacesContext;
import org.seasar.teeda.core.mock.NullFacesEvent;
import org.seasar.teeda.core.mock.NullFacesListener;
import org.seasar.teeda.core.mock.NullUIComponent;
import org.seasar.teeda.core.unit.ExceptionAssert;

public class UIComponentBaseTest
extends AbstractUIComponentTest {
    private MockFacesContext facesContext_;

    public void testSetGetValueBinding() {
        UIComponentBase component = this.createUIComponentBase();
        MockValueBinding vb = new MockValueBinding();
        component.setValueBinding("hoge", (ValueBinding)vb);
        UIComponentBaseTest.assertTrue((vb == component.getValueBinding("hoge") ? 1 : 0) != 0);
    }

    public void testSetGetId() {
        UIComponentBase component = this.createUIComponentBase();
        UIComponentBaseTest.assertEquals(null, (String)component.getId());
        component.setId("a12345");
        UIComponentBaseTest.assertEquals((String)"a12345", (String)component.getId());
    }

    public void testSetGetId2() {
        UIComponentBase component = this.createUIComponentBase();
        UIComponentBaseTest.assertEquals(null, (String)component.getId());
        try {
            component.setId("#{a}");
            UIComponentBaseTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetParent() {
        UIComponentBase component = this.createUIComponentBase();
        UIComponentBaseTest.assertEquals(null, (Object)component.getParent());
        UIComponent parent = this.createUIComponent();
        component.setParent(parent);
        UIComponentBaseTest.assertSame((Object)parent, (Object)component.getParent());
    }

    public void testSetGetRendered() throws Exception {
        UIComponentBase componentBase = this.createUIComponentBase();
        componentBase.setRendered(false);
        UIComponentBaseTest.assertEquals((boolean)false, (boolean)componentBase.isRendered());
    }

    public void testSetGetRendered_ValueBinding() throws Exception {
        UIComponentBase componentBase = this.createUIComponentBase();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)Boolean.FALSE);
        componentBase.setValueBinding("rendered", (ValueBinding)vb);
        UIComponentBaseTest.assertEquals((boolean)false, (boolean)componentBase.isRendered());
    }

    public void testSetGetRendererType() throws Exception {
        UIComponentBase componentBase = this.createUIComponentBase();
        componentBase.setRendererType("foo rendererType");
        UIComponentBaseTest.assertEquals((String)"foo rendererType", (String)componentBase.getRendererType());
    }

    public void testSetGetRendererType_ValueBinding() throws Exception {
        UIComponentBase componentBase = this.createUIComponentBase();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)"bar rendererType");
        componentBase.setRendererType(null);
        componentBase.setValueBinding("rendererType", (ValueBinding)vb);
        UIComponentBaseTest.assertEquals((String)"bar rendererType", (String)componentBase.getRendererType());
    }

    public void testGetChildCount() {
        UIComponentBase component = this.createUIComponentBase();
        UIComponentBaseTest.assertEquals((int)0, (int)component.getChildCount());
        component.getChildren().add(new MockUIComponent());
        UIComponentBaseTest.assertEquals((int)1, (int)component.getChildCount());
        component.getChildren().add(new MockUIComponent());
        UIComponentBaseTest.assertEquals((int)2, (int)component.getChildCount());
        component.getChildren().add(new MockUIComponent());
        UIComponentBaseTest.assertEquals((int)3, (int)component.getChildCount());
    }

    public void testGetChildren() {
        UIComponentBase component = this.createUIComponentBase();
        UIComponentBaseTest.assertEquals((int)0, (int)component.getChildCount());
        MockUIComponent child1 = new MockUIComponent();
        MockUIComponent child2 = new MockUIComponent();
        MockUIComponent child3 = new MockUIComponent();
        component.getChildren().add(child1);
        component.getChildren().add(child2);
        component.getChildren().add(child3);
        UIComponentBaseTest.assertSame((Object)child1, component.getChildren().get(0));
        UIComponentBaseTest.assertSame((Object)child2, component.getChildren().get(1));
        UIComponentBaseTest.assertSame((Object)child3, component.getChildren().get(2));
    }

    public void testFindComponent() {
        UIComponentBase component = this.createUIComponentBase();
        component.setId("aa");
        UIComponent found = component.findComponent("aa");
        UIComponentBaseTest.assertSame((Object)component, (Object)found);
    }

    public void testFindComponent_Absolute() {
        UIComponentBase component = this.createUIComponentBase();
        component.setId("aa");
        UIComponent found = component.findComponent(":aa");
        UIComponentBaseTest.assertSame((Object)component, (Object)found);
    }

    public void testFindComponent_Parent() {
        UIComponentBase component = this.createUIComponentBase();
        component.setId("aa");
        MockUIComponentBase parent = new MockUIComponentBase();
        parent.setId("bb");
        parent.getChildren().add(component);
        UIComponent found = component.findComponent("bb");
        if (component instanceof NamingContainer) {
            UIComponentBaseTest.assertEquals(null, (Object)found);
        } else {
            UIComponentBaseTest.assertSame((Object)((Object)parent), (Object)found);
        }
    }

    public void testFindComponent_FromParent() {
        UIComponentBase component = this.createUIComponentBase();
        component.setId("aa");
        MockUIComponentBase parent = new MockUIComponentBase();
        parent.setId("bb");
        parent.getChildren().add(component);
        UIComponent found = component.findComponent("aa");
        UIComponentBaseTest.assertSame((Object)component, (Object)found);
    }

    public void testFindComponent_NotSearchFromDescendantNamingContainer() {
        UIComponentBase component = this.createUIComponentBase();
        component.setId("foo");
        MockUIComponent bottom = new MockUIComponent();
        bottom.setId("bb");
        UIForm namingContainer = new UIForm();
        namingContainer.setId("aa");
        namingContainer.getChildren().add(bottom);
        component.getChildren().add(namingContainer);
        UIComponent found = component.findComponent("bb");
        UIComponentBaseTest.assertEquals(null, (Object)found);
    }

    public void testFindComponent_SearchDescendant() {
        UIComponentBase component = this.createUIComponentBase();
        component.setId("foo");
        MockUIComponentBase target = new MockUIComponentBase();
        target.setId("bb");
        MockUIComponentBase noNamingContainerParent = new MockUIComponentBase();
        noNamingContainerParent.setId("aa");
        noNamingContainerParent.getChildren().add(target);
        noNamingContainerParent.getChildren().add(component);
        UIComponent found = component.findComponent("bb");
        if (component instanceof NamingContainer) {
            UIComponentBaseTest.assertEquals(null, (Object)found);
        } else {
            UIComponentBaseTest.assertEquals((Object)((Object)target), (Object)found);
        }
    }

    public void testFindComponent_SearchFromDescendantNamingContainer() {
        UIComponentBase component = this.createUIComponentBase();
        component.setId("foo");
        MockUIComponent target = new MockUIComponent();
        target.setId("bb");
        UIForm namingContainer = new UIForm();
        namingContainer.setId("aa");
        namingContainer.getChildren().add(target);
        component.getChildren().add(namingContainer);
        UIComponent found = component.findComponent("aa:bb");
        UIComponentBaseTest.assertSame((Object)target, (Object)found);
    }

    public void testFindComponent_SearchFromAncestorNamingContainer() {
        UIComponentBase component = this.createUIComponentBase();
        component.setId("foo");
        MockUIComponent target = new MockUIComponent();
        target.setId("bb");
        UIForm namingContainerParent = new UIForm();
        namingContainerParent.setId("aa");
        namingContainerParent.getChildren().add(target);
        namingContainerParent.getChildren().add(component);
        UIComponent found = component.findComponent("aa:bb");
        if (component instanceof NamingContainer) {
            UIComponentBaseTest.assertEquals(null, (Object)found);
        } else {
            UIComponentBaseTest.assertSame((Object)target, (Object)found);
        }
    }

    public void testFindComponent_NestedNamingContainer() {
        UIComponentBase component = this.createUIComponentBase();
        component.setId("foo");
        MockUIComponent target = new MockUIComponent();
        target.setId("z");
        UIForm namingContainer1 = new UIForm();
        namingContainer1.setId("a");
        namingContainer1.getChildren().add(component);
        UIForm namingContainer2 = new UIForm();
        namingContainer2.setId("b");
        namingContainer1.getChildren().add(namingContainer2);
        namingContainer2.getChildren().add(target);
        UIComponent found = component.findComponent("a:b:z");
        if (component instanceof NamingContainer) {
            UIComponentBaseTest.assertEquals(null, (Object)found);
        } else {
            UIComponentBaseTest.assertSame((Object)target, (Object)found);
        }
    }

    public void testFindComponent_IntermediateUIComponentIsNotNamingContainer() {
        UIComponentBase component = this.createUIComponentBase();
        component.setId("foo");
        MockUIComponent target = new MockUIComponent();
        target.setId("z");
        UIForm namingContainer = new UIForm();
        namingContainer.setId("a");
        namingContainer.getChildren().add(component);
        MockUIComponentBase noNamingContainer = new MockUIComponentBase();
        noNamingContainer.setId("b");
        namingContainer.getChildren().add(noNamingContainer);
        noNamingContainer.getChildren().add(target);
        if (component instanceof NamingContainer) {
            component.findComponent("a:b:z");
        } else {
            try {
                component.findComponent("a:b:z");
                UIComponentBaseTest.fail();
            }
            catch (IllegalArgumentException iae) {
                ExceptionAssert.assertMessageExist(iae);
            }
        }
    }

    public void testGetFacetsAndFacet() {
        UIComponentBase component = this.createUIComponentBase();
        NullUIComponent facet1 = new NullUIComponent();
        component.getFacets().put("a", facet1);
        UIComponentBaseTest.assertSame((Object)((Object)facet1), component.getFacets().get("a"));
        UIComponentBaseTest.assertEquals(null, component.getFacets().get("b"));
        UIComponentBaseTest.assertSame((Object)((Object)facet1), (Object)component.getFacet("a"));
        UIComponentBaseTest.assertEquals(null, (Object)component.getFacet("b"));
    }

    public void testGetFacetsAndChildren() {
        UIComponentBase component = this.createUIComponentBase();
        UIComponentBaseTest.assertEquals((int)0, (int)component.getChildCount());
        MockUIComponent child1 = new MockUIComponent();
        MockUIComponent child2 = new MockUIComponent();
        MockUIComponent child3 = new MockUIComponent();
        MockUIComponent facet1 = new MockUIComponent();
        MockUIComponent facet2 = new MockUIComponent();
        component.getChildren().add(child1);
        component.getFacets().put("facet1", facet1);
        component.getChildren().add(child2);
        component.getFacets().put("facet2", facet2);
        component.getChildren().add(child3);
        Iterator it = component.getFacetsAndChildren();
        UIComponentBaseTest.assertSame((Object)facet1, (Object)((UIComponent)it.next()));
        UIComponentBaseTest.assertSame((Object)facet2, (Object)((UIComponent)it.next()));
        UIComponentBaseTest.assertSame((Object)child1, (Object)((UIComponent)it.next()));
        UIComponentBaseTest.assertSame((Object)child2, (Object)((UIComponent)it.next()));
        UIComponentBaseTest.assertSame((Object)child3, (Object)((UIComponent)it.next()));
    }

    public void testGetFacetsAndChildren_EmptyIterator() throws Exception {
        UIComponentBase component = this.createUIComponentBase();
        Iterator it = component.getFacetsAndChildren();
        UIComponentBaseTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testGetFacetsAndChildren_IteratorNotSupportRemove() throws Exception {
        UIComponentBase component = this.createUIComponentBase();
        Iterator it = component.getFacetsAndChildren();
        try {
            it.remove();
        }
        catch (UnsupportedOperationException uoe) {
            ExceptionAssert.assertMessageExist(uoe);
        }
    }

    public final void testBroadcast() throws Exception {
        UIComponentBase component = this.createUIComponentBase();
        NullFacesListener facesListener1 = new NullFacesListener();
        component.addFacesListener((FacesListener)facesListener1);
        NullFacesListener facesListener2 = new NullFacesListener();
        component.addFacesListener((FacesListener)facesListener2);
        final ArrayList args = new ArrayList();
        NullFacesEvent facesEvent = new NullFacesEvent(){
            private static final long serialVersionUID = 1L;

            public boolean isAppropriateListener(FacesListener listener) {
                args.add(listener);
                return true;
            }

            public void processListener(FacesListener listener) {
                args.add(listener);
            }
        };
        component.broadcast((FacesEvent)facesEvent);
        UIComponentBaseTest.assertEquals((int)4, (int)args.size());
        UIComponentBaseTest.assertSame((Object)facesListener1, args.get(0));
        UIComponentBaseTest.assertSame((Object)facesListener1, args.get(1));
        UIComponentBaseTest.assertSame((Object)facesListener2, args.get(2));
        UIComponentBaseTest.assertSame((Object)facesListener2, args.get(3));
    }

    public void testHandleFacesListeners() throws Exception {
        UIComponentBase component = this.createUIComponentBase();
        try {
            component.addFacesListener(null);
            UIComponentBaseTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
        FacesListener listener1 = new FacesListener(){

            public String toString() {
                return "1";
            }
        };
        FacesListener listener2 = new FacesListener(){

            public String toString() {
                return "2";
            }
        };
        component.addFacesListener(listener1);
        component.addFacesListener(listener2);
        FacesListener[] listeners = component.getFacesListeners(FacesListener.class);
        UIComponentBaseTest.assertEquals((String)"Assert all FacesListner", (int)2, (int)listeners.length);
        component.removeFacesListener(listener2);
        listeners = component.getFacesListeners(FacesListener.class);
        UIComponentBaseTest.assertEquals((String)"Should be just one listener", (int)1, (int)listeners.length);
        UIComponentBaseTest.assertEquals((String)"1", (String)listeners[0].toString());
    }

    public void testHandleFacesListeners2() {
        UIComponentBase component = this.createUIComponentBase();
        MockFacesListener1 listener1 = new MockFacesListener1();
        MockFacesListener2 listener2 = new MockFacesListener2();
        component.addFacesListener((FacesListener)listener1);
        component.addFacesListener((FacesListener)listener2);
        FacesListener[] listeners1 = component.getFacesListeners(MockFacesListener1.class);
        UIComponentBaseTest.assertEquals((int)1, (int)listeners1.length);
        FacesListener[] listeners2 = component.getFacesListeners(MockFacesListener2.class);
        UIComponentBaseTest.assertEquals((int)1, (int)listeners2.length);
    }

    public void testQueueEvent_WithParent() throws Exception {
        UIComponentBase component = this.createUIComponentBase();
        MockUIComponent parent = new MockUIComponent();
        component.setParent((UIComponent)parent);
        NullFacesEvent event = new NullFacesEvent();
        component.queueEvent((FacesEvent)event);
        UIComponentBaseTest.assertNotNull((Object)parent.getQueueEvent());
        UIComponentBaseTest.assertSame((Object)((Object)event), (Object)parent.getQueueEvent());
    }

    public final void testProcessSaveState_TransientTrue() throws Exception {
        UIComponentBase component = this.createUIComponentBase();
        component.setTransient(true);
        Object state = component.processSaveState((FacesContext)this.getFacesContext());
        UIComponentBaseTest.assertEquals(null, (Object)state);
    }

    public void testProcessSaveState() throws Exception {
        final ArrayList callSeq = new ArrayList();
        UIComponentBase component = this.createUIComponentBase();
        component.getChildren().add(new NullUIComponent(){

            public Object processSaveState(FacesContext context) {
                callSeq.add("1");
                return "1";
            }
        });
        component.getChildren().add(new NullUIComponent(){

            public Object processSaveState(FacesContext context) {
                callSeq.add("2");
                return "1";
            }
        });
        component.getFacets().put("A", new NullUIComponent(){

            public Object processSaveState(FacesContext context) {
                callSeq.add("3");
                return "1";
            }
        });
        component.getFacets().put("B", new NullUIComponent(){

            public Object processSaveState(FacesContext context) {
                callSeq.add("4");
                return "1";
            }
        });
        Object state = component.processSaveState((FacesContext)this.getFacesContext());
        UIComponentBaseTest.assertEquals((int)4, (int)callSeq.size());
        ObjectAssert.assertInstanceOf((Class)Serializable.class, (Object)state);
    }

    public void testProcessRestoreState_NoSerializableStateHolder() throws Exception {
        UIComponentBase component = this.createUIComponentBase();
        try {
            component.processRestoreState((FacesContext)this.getFacesContext(), new ArrayList());
            UIComponentBaseTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public final void testSaveAndRestoreAttachedState_AttacedObjectIsNull() {
        NullFacesContext context = new NullFacesContext();
        Object stateObj = UIComponentBase.saveAttachedState((FacesContext)context, null);
        UIComponentBase.restoreAttachedState((FacesContext)context, (Object)stateObj);
    }

    public final void testSaveAndRestoreAttachedState_AttacedObjectIsList() throws Exception {
        NullFacesContext context = new NullFacesContext();
        AttachedObjectStateWrapper wrapper = new AttachedObjectStateWrapper((FacesContext)context, (Object)new Hoge());
        ArrayList<AttachedObjectStateWrapper> restoreList = new ArrayList<AttachedObjectStateWrapper>();
        restoreList.add(wrapper);
        List restoredList = (List)UIComponentBase.restoreAttachedState((FacesContext)context, restoreList);
        UIComponentBaseTest.assertNotNull((Object)restoredList);
        UIComponentBaseTest.assertTrue((restoredList.size() == 1 ? 1 : 0) != 0);
    }

    private UIComponentBase createUIComponentBase() {
        return (UIComponentBase)this.createUIComponent();
    }

    protected UIComponent createUIComponent() {
        return new MockUIComponentBase();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.facesContext_ = new MockFacesContextImpl();
    }

    protected void tearDown() throws Exception {
        this.facesContext_.release();
        super.tearDown();
    }

    public MockFacesContext getFacesContext() {
        return this.facesContext_;
    }

    public static class Hoge {
    }

    private static class MockFacesListener2
    implements FacesListener {
        private MockFacesListener2() {
        }

        public String toString() {
            return "mock2";
        }
    }

    private static class MockFacesListener1
    implements FacesListener {
        private MockFacesListener1() {
        }

        public String toString() {
            return "mock1";
        }
    }
}

