/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.lifecycle.impl;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.internal.SubApplicationUtil;
import javax.faces.internal.WindowIdUtil;
import javax.faces.internal.scope.PageScope;
import javax.faces.internal.scope.SubApplicationScope;
import org.seasar.framework.util.LruHashMap;
import org.seasar.teeda.core.lifecycle.AbstractPhase;
import org.seasar.teeda.core.util.ExternalContextUtil;
import org.seasar.teeda.core.util.FacesContextUtil;
import org.seasar.teeda.core.util.PortletUtil;
import org.seasar.teeda.core.util.PostbackUtil;
import org.seasar.teeda.core.util.ServletExternalContextUtil;

public class RestoreViewPhase
extends AbstractPhase {
    private static final String VIEW_ID_LRU_ATTR = RestoreViewPhase.class.getName() + ".VIEW_ID_LRU";
    private int viewIdLruSize = 16;

    public int getViewIdLruSize() {
        return this.viewIdLruSize;
    }

    public void setViewIdLruSize(int viewIdLruSize) {
        this.viewIdLruSize = viewIdLruSize;
    }

    protected void executePhase(FacesContext context) throws FacesException {
        RestoreValueHolder holder = this.setUpRestoreViewPhase(context);
        String viewId = holder.getCurrentViewId();
        String wid = holder.getWid();
        String previousViewId = holder.getPreviousViewId();
        if (previousViewId != null && !previousViewId.equals(viewId)) {
            PageScope.removeContext(context, wid);
        }
        String subAppPath = SubApplicationUtil.getSubApplicationPath(viewId);
        String previousSubAppPath = SubApplicationUtil.getSubApplicationPath(previousViewId);
        if (previousSubAppPath != null && !previousSubAppPath.equals(subAppPath)) {
            SubApplicationScope.removeContext(context, wid);
        }
        UIViewRoot viewRoot = this.composeViewRoot(context, viewId);
        context.setViewRoot(viewRoot);
        ExternalContext externalContext = context.getExternalContext();
        this.saveViewIdToSession(externalContext.getSessionMap(), wid, viewId);
        this.initializeChildren(context, viewRoot);
        Map requestParameterMap = externalContext.getRequestParameterMap();
        if (requestParameterMap.isEmpty()) {
            context.renderResponse();
        }
    }

    protected RestoreValueHolder setUpRestoreViewPhase(FacesContext context) {
        RestoreValueHolder holder = new RestoreValueHolder(context);
        ExternalContext externalContext = context.getExternalContext();
        String previousViewId = holder.getPreviousViewId();
        Map requestMap = externalContext.getRequestMap();
        requestMap.put("previousViewId", previousViewId);
        boolean isPost = true;
        isPost = !PortletUtil.isPortlet(context) ? ServletExternalContextUtil.isPost(externalContext) : !PortletUtil.isRender(context);
        PostbackUtil.setPostback(requestMap, isPost);
        return holder;
    }

    private UIViewRoot composeViewRoot(FacesContext context, String viewId) {
        ViewHandler viewHandler = FacesContextUtil.getViewHandler(context);
        UIViewRoot viewRoot = viewHandler.restoreView(context, viewId);
        if (viewRoot != null) {
            Locale locale = viewHandler.calculateLocale(context);
            if (locale != null) {
                viewRoot.setLocale(locale);
            }
        } else {
            viewRoot = viewHandler.createView(context, viewId);
        }
        return viewRoot;
    }

    private String getViewId(FacesContext context, ExternalContext externalContext) {
        return ExternalContextUtil.getViewId(externalContext);
    }

    protected String getViewIdFromSession(Map sessionMap, String windowId) {
        Map lru = this.getViewIdLruFromSession(sessionMap);
        return (String)lru.get(windowId);
    }

    protected synchronized Map getViewIdLruFromSession(Map sessionMap) {
        Map lru = (Map)sessionMap.get(VIEW_ID_LRU_ATTR);
        if (lru == null) {
            lru = Collections.synchronizedMap(new LruHashMap(this.viewIdLruSize));
            sessionMap.put(VIEW_ID_LRU_ATTR, lru);
        }
        return lru;
    }

    protected void saveViewIdToSession(Map sessionMap, String windowId, String viewId) {
        Map lru = this.getViewIdLruFromSession(sessionMap);
        lru.put(windowId, viewId);
    }

    protected PhaseId getCurrentPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    private class RestoreValueHolder {
        private String currentViewId;
        private String wid;
        private String previousViewId;

        public RestoreValueHolder(FacesContext context) {
            ExternalContext externalContext = context.getExternalContext();
            this.currentViewId = RestoreViewPhase.this.getViewId(context, externalContext);
            this.wid = WindowIdUtil.getWindowId(externalContext);
            this.previousViewId = RestoreViewPhase.this.getViewIdFromSession(externalContext.getSessionMap(), this.wid);
        }

        public String getCurrentViewId() {
            return this.currentViewId;
        }

        public String getWid() {
            return this.wid;
        }

        public String getPreviousViewId() {
            return this.previousViewId;
        }
    }
}

