/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBaseTest;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import junitx.framework.ObjectAssert;
import org.seasar.teeda.core.mock.MockActionListener;
import org.seasar.teeda.core.mock.MockMethodBinding;
import org.seasar.teeda.core.mock.MockUIComponentBase;
import org.seasar.teeda.core.mock.MockValueBinding;
import org.seasar.teeda.core.mock.NullFacesEvent;
import org.seasar.teeda.core.mock.NullUIComponent;

public class UICommandTest
extends UIComponentBaseTest {
    public final void testSetGetAction() {
        UICommand command = this.createUICommand();
        MockMethodBinding mb = new MockMethodBinding();
        command.setAction((MethodBinding)mb);
        UICommandTest.assertEquals((Object)mb, (Object)command.getAction());
    }

    public final void testSetGetAction_ValueBindingNotWork() {
        UICommand command = this.createUICommand();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new MockMethodBinding());
        command.setValueBinding("action", (ValueBinding)vb);
        UICommandTest.assertEquals(null, (Object)command.getAction());
    }

    public final void testSetGetActionListener() {
        UICommand command = this.createUICommand();
        MockMethodBinding mb = new MockMethodBinding();
        command.setActionListener((MethodBinding)mb);
        UICommandTest.assertEquals((Object)mb, (Object)command.getActionListener());
    }

    public final void testSetGetActionListener_ValueBindingNotWork() {
        UICommand command = this.createUICommand();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new MockMethodBinding());
        command.setValueBinding("action", (ValueBinding)vb);
        UICommandTest.assertEquals(null, (Object)command.getActionListener());
    }

    public final void testSetGetImmediate() {
        UICommand command = this.createUICommand();
        command.setImmediate(true);
        UICommandTest.assertEquals((boolean)true, (boolean)command.isImmediate());
    }

    public final void testSetGetImmediate_ValueBinding() {
        UICommand command = this.createUICommand();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Boolean(true));
        command.setValueBinding("immediate", (ValueBinding)vb);
        UICommandTest.assertEquals((boolean)true, (boolean)command.isImmediate());
    }

    public final void testAddGetRemoveActionListeners() throws Exception {
        UICommand command = this.createUICommand();
        UICommandTest.assertEquals((int)0, (int)command.getActionListeners().length);
        MockActionListener v1 = new MockActionListener();
        MockActionListener v2 = new MockActionListener();
        MockActionListener v3 = new MockActionListener();
        command.addActionListener((ActionListener)v1);
        UICommandTest.assertEquals((int)1, (int)command.getActionListeners().length);
        command.addActionListener((ActionListener)v2);
        UICommandTest.assertEquals((int)2, (int)command.getActionListeners().length);
        command.addActionListener((ActionListener)v3);
        UICommandTest.assertEquals((int)3, (int)command.getActionListeners().length);
        command.removeActionListener((ActionListener)v2);
        UICommandTest.assertEquals((int)2, (int)command.getActionListeners().length);
        command.removeActionListener((ActionListener)v2);
        UICommandTest.assertEquals((int)2, (int)command.getActionListeners().length);
    }

    public final void testBroadcast_ToDefaultActionListener() throws Exception {
        UICommand command = this.createUICommand();
        ActionEvent actionEvent = new ActionEvent((UIComponent)new NullUIComponent());
        MockActionListener actionListener = new MockActionListener();
        this.getFacesContext().getApplication().setActionListener((ActionListener)actionListener);
        command.broadcast((FacesEvent)actionEvent);
        UICommandTest.assertSame((Object)actionEvent, (Object)actionListener.getEvent());
    }

    public final void testBroadcast_ToMethodReferencedActionListener() throws Exception {
        UICommand command = this.createUICommand();
        MockMethodBinding mb = new MockMethodBinding();
        command.setActionListener((MethodBinding)mb);
        ActionEvent actionEvent = new ActionEvent((UIComponent)new NullUIComponent());
        MockActionListener actionListener = new MockActionListener();
        this.getFacesContext().getApplication().setActionListener((ActionListener)actionListener);
        command.broadcast((FacesEvent)actionEvent);
        UICommandTest.assertEquals((boolean)true, (boolean)mb.isInvokeCalled());
        UICommandTest.assertSame((Object)actionEvent, (Object)mb.getInvokeParams()[0]);
    }

    public final void testBroadcast_NoActionEvent() throws Exception {
        UICommand command = this.createUICommand();
        MockMethodBinding mb = new MockMethodBinding();
        command.setActionListener((MethodBinding)mb);
        NullFacesEvent noActionEvent = new NullFacesEvent();
        ObjectAssert.assertNotInstanceOf((Class)ActionEvent.class, (Object)((Object)noActionEvent));
        MockActionListener actionListener = new MockActionListener();
        this.getFacesContext().getApplication().setActionListener((ActionListener)actionListener);
        command.broadcast((FacesEvent)noActionEvent);
        UICommandTest.assertEquals(null, (Object)actionListener.getEvent());
        UICommandTest.assertEquals((boolean)false, (boolean)mb.isInvokeCalled());
    }

    public final void testQueueEvent_ImmediateTrue() throws Exception {
        final Object[] args = new Object[]{null};
        MockUIComponentBase parent = new MockUIComponentBase(){

            public void queueEvent(FacesEvent event) {
                args[0] = event;
            }
        };
        UICommand command = this.createUICommand();
        command.setImmediate(true);
        parent.getChildren().add(command);
        ActionEvent actionEvent = new ActionEvent((UIComponent)new NullUIComponent());
        command.queueEvent((FacesEvent)actionEvent);
        UICommandTest.assertEquals((Object)PhaseId.APPLY_REQUEST_VALUES, (Object)actionEvent.getPhaseId());
        UICommandTest.assertSame((Object)actionEvent, (Object)args[0]);
    }

    public final void testQueueEvent_ImmediateFalse() throws Exception {
        final Object[] args = new Object[]{null};
        MockUIComponentBase parent = new MockUIComponentBase(){

            public void queueEvent(FacesEvent event) {
                args[0] = event;
            }
        };
        UICommand command = this.createUICommand();
        command.setImmediate(false);
        parent.getChildren().add(command);
        ActionEvent actionEvent = new ActionEvent((UIComponent)new NullUIComponent());
        command.queueEvent((FacesEvent)actionEvent);
        UICommandTest.assertEquals((Object)PhaseId.INVOKE_APPLICATION, (Object)actionEvent.getPhaseId());
        UICommandTest.assertSame((Object)actionEvent, (Object)args[0]);
    }

    public final void testQueueEvent_WithNotActionEvent() throws Exception {
        final Object[] args = new Object[]{null};
        MockUIComponentBase parent = new MockUIComponentBase(){

            public void queueEvent(FacesEvent event) {
                args[0] = event;
            }
        };
        UICommand command = this.createUICommand();
        command.setImmediate(false);
        parent.getChildren().add(command);
        NullFacesEvent noActionEvent = new NullFacesEvent();
        ObjectAssert.assertNotInstanceOf((Class)ActionEvent.class, (Object)((Object)noActionEvent));
        command.queueEvent((FacesEvent)noActionEvent);
        UICommandTest.assertEquals((Object)PhaseId.ANY_PHASE, (Object)noActionEvent.getPhaseId());
        UICommandTest.assertSame((Object)((Object)noActionEvent), (Object)args[0]);
    }

    private UICommand createUICommand() {
        return (UICommand)this.createUIComponent();
    }

    protected UIComponent createUIComponent() {
        return new UICommand();
    }
}

