/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.ajax;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.seasar.teeda.ajax.JSONSerializer;

public class JSONSerializerTest
extends TestCase {
    public void testToString_null() throws Exception {
        JSONSerializerTest.assertEquals((String)"null", (String)JSONSerializer.serialize(null));
    }

    public void testToJson_boolean() throws Exception {
        JSONSerializerTest.assertEquals((String)"true", (String)JSONSerializer.serialize((Object)Boolean.TRUE));
        JSONSerializerTest.assertEquals((String)"false", (String)JSONSerializer.serialize((Object)Boolean.FALSE));
    }

    public void testToJson_string() throws Exception {
        JSONSerializerTest.assertEquals((String)"\"a\"", (String)JSONSerializer.serialize((Object)"a"));
    }

    public void testToJson_float() throws Exception {
        JSONSerializerTest.assertEquals((String)"1.0", (String)JSONSerializer.serialize((Object)new Float(1.0f)));
        try {
            JSONSerializer.serialize((Object)new Float(Float.NaN));
            JSONSerializerTest.fail();
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
    }

    public void testToJson_double() throws Exception {
        JSONSerializerTest.assertEquals((String)"1.0", (String)JSONSerializer.serialize((Object)new Double(1.0)));
        try {
            JSONSerializer.serialize((Object)new Double(Double.NaN));
            JSONSerializerTest.fail();
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
    }

    public void testToJson_number() throws Exception {
        JSONSerializerTest.assertEquals((String)"100", (String)JSONSerializer.serialize((Object)new Integer(100)));
    }

    public void testToJson_array() throws Exception {
        JSONSerializerTest.assertEquals((String)"[]", (String)JSONSerializer.serialize((Object)new Object[0]));
        JSONSerializerTest.assertEquals((String)"[1]", (String)JSONSerializer.serialize((Object)new Integer[]{new Integer(1)}));
        JSONSerializerTest.assertEquals((String)"[1,2]", (String)JSONSerializer.serialize((Object)new Integer[]{new Integer(1), new Integer(2)}));
    }

    public void testToJson_collection() throws Exception {
        JSONSerializerTest.assertEquals((String)"[]", (String)JSONSerializer.serialize(new ArrayList()));
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(new Integer(1));
        JSONSerializerTest.assertEquals((String)"[1]", (String)JSONSerializer.serialize(list));
    }

    public void testToJson_map() throws Exception {
        JSONSerializerTest.assertEquals((String)"{}", (String)JSONSerializer.serialize(new HashMap()));
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("aaa", new Integer(1));
        JSONSerializerTest.assertEquals((String)"{\"aaa\":1}", (String)JSONSerializer.serialize(map));
        map.put("bbb", new Integer(2));
        JSONSerializerTest.assertEquals((String)"{\"aaa\":1,\"bbb\":2}", (String)JSONSerializer.serialize(map));
        map.put("bbb", new HashMap());
        JSONSerializerTest.assertEquals((String)"{\"aaa\":1,\"bbb\":{}}", (String)JSONSerializer.serialize(map));
    }

    public void testToJson_map2() throws Exception {
        HashMap<String, String[]> child1 = new HashMap<String, String[]>();
        child1.put("aaa", new String[]{"aaa", "bbb", "ccc"});
        HashMap<String, String[]> child2 = new HashMap<String, String[]>();
        child2.put("bbb", new String[]{"AAA", "BBB", "CCC"});
        HashMap<String, Map[]> parent = new HashMap<String, Map[]>();
        parent.put("map", new Map[]{child1, child2});
        String s = JSONSerializer.serialize(parent);
        System.out.println(s);
        Map eval = (Map)JSONSerializer.eval((String)s);
        JSONSerializerTest.assertNotNull((Object)eval);
        System.out.println(eval);
        Object o = eval.get("map");
        List maps = (List)o;
        Map ret = (Map)maps.get(0);
        System.out.println(ret.get("aaa"));
    }

    public void testToJson_map3() throws Exception {
        Hoge hoge = new Hoge();
        String s = JSONSerializer.serialize((Object)hoge);
        System.out.println(s);
        Map eval = (Map)JSONSerializer.eval((String)s);
        JSONSerializerTest.assertNotNull((Object)eval);
        Object o = eval.get("map");
        JSONSerializerTest.assertNotNull(o);
        Map map = (Map)o;
        List maplist = (List)map.get("maplist");
        Map aaamap = (Map)maplist.get(0);
        List strsList1 = (List)aaamap.get("aaa");
        JSONSerializerTest.assertNotNull((Object)strsList1);
        JSONSerializerTest.assertTrue((strsList1.size() == 3 ? 1 : 0) != 0);
        JSONSerializerTest.assertEquals((Object)"aaa", strsList1.get(0));
        JSONSerializerTest.assertEquals((Object)"bbb", strsList1.get(1));
        JSONSerializerTest.assertEquals((Object)"ccc", strsList1.get(2));
        Map bbbmap = (Map)maplist.get(1);
        List strsList2 = (List)bbbmap.get("bbb");
        JSONSerializerTest.assertNotNull((Object)strsList2);
        JSONSerializerTest.assertTrue((strsList2.size() == 3 ? 1 : 0) != 0);
        JSONSerializerTest.assertEquals((Object)"AAA", strsList2.get(0));
        JSONSerializerTest.assertEquals((Object)"BBB", strsList2.get(1));
        JSONSerializerTest.assertEquals((Object)"CCC", strsList2.get(2));
    }

    public void testToJson_map4() throws Exception {
        Hoge2 hoge = new Hoge2();
        String s = JSONSerializer.serialize((Object)hoge);
        System.out.println(s);
        Map eval = (Map)JSONSerializer.eval((String)s);
        JSONSerializerTest.assertNotNull((Object)eval);
        Object o = eval.get("map");
        JSONSerializerTest.assertNotNull(o);
        Map map = (Map)o;
        List maplist = (List)map.get("maplist");
        Map aaamap = (Map)maplist.get(0);
        List strsList1 = (List)aaamap.get("aaa");
        JSONSerializerTest.assertNotNull((Object)strsList1);
        JSONSerializerTest.assertTrue((strsList1.size() == 3 ? 1 : 0) != 0);
        JSONSerializerTest.assertEquals((Object)"aaa", strsList1.get(0));
        JSONSerializerTest.assertEquals((Object)"bbb", strsList1.get(1));
        JSONSerializerTest.assertEquals((Object)"ccc", strsList1.get(2));
        List ccclist = (List)aaamap.get("ccc");
        JSONSerializerTest.assertNotNull((Object)ccclist);
        JSONSerializerTest.assertTrue((ccclist.size() == 2 ? 1 : 0) != 0);
        JSONSerializerTest.assertEquals((Object)new Integer(1), ccclist.get(0));
        JSONSerializerTest.assertEquals((Object)new Integer(2), ccclist.get(1));
        Map bbbmap = (Map)maplist.get(1);
        List strsList2 = (List)bbbmap.get("bbb");
        JSONSerializerTest.assertNotNull((Object)strsList2);
        JSONSerializerTest.assertTrue((strsList2.size() == 3 ? 1 : 0) != 0);
        JSONSerializerTest.assertEquals((Object)"AAA", strsList2.get(0));
        JSONSerializerTest.assertEquals((Object)"BBB", strsList2.get(1));
        JSONSerializerTest.assertEquals((Object)"CCC", strsList2.get(2));
    }

    public void testToJson_map5() throws Exception {
        Hoge3 hoge = new Hoge3();
        String s = JSONSerializer.serialize((Object)hoge);
        System.out.println(s);
        Object eval = JSONSerializer.eval((String)s);
        JSONSerializerTest.assertNotNull((Object)eval);
        Map root = (Map)eval;
        List list = (List)root.get("list");
        Map child1 = (Map)list.get(0);
        JSONSerializerTest.assertNotNull((Object)child1);
        JSONSerializerTest.assertTrue((child1.size() == 2 ? 1 : 0) != 0);
        List aaalist = (List)child1.get("aaa");
        JSONSerializerTest.assertNotNull((Object)aaalist);
        JSONSerializerTest.assertTrue((aaalist.size() == 3 ? 1 : 0) != 0);
        List ccclist = (List)child1.get("ccc");
        JSONSerializerTest.assertNotNull((Object)ccclist);
        JSONSerializerTest.assertTrue((ccclist.size() == 2 ? 1 : 0) != 0);
        Map child2 = (Map)list.get(1);
        JSONSerializerTest.assertNotNull((Object)child2);
        JSONSerializerTest.assertTrue((child2.size() == 1 ? 1 : 0) != 0);
        List bbblist = (List)child2.get("bbb");
        JSONSerializerTest.assertNotNull((Object)bbblist);
        JSONSerializerTest.assertTrue((bbblist.size() == 3 ? 1 : 0) != 0);
        JSONSerializerTest.assertEquals((Object)"AAA", bbblist.get(0));
        JSONSerializerTest.assertEquals((Object)"BBB", bbblist.get(1));
        JSONSerializerTest.assertEquals((Object)"CCC", bbblist.get(2));
    }

    public void testToJson_PrimitiveArray() throws Exception {
        JSONSerializerTest.assertEquals((String)"[1]", (String)JSONSerializer.serialize((Object)new int[]{1}));
        JSONSerializerTest.assertEquals((String)"[1,2,3]", (String)JSONSerializer.serialize((Object)new int[]{1, 2, 3}));
        JSONSerializerTest.assertEquals((String)"[true]", (String)JSONSerializer.serialize((Object)new boolean[]{true}));
        JSONSerializerTest.assertEquals((String)"[true,false,true]", (String)JSONSerializer.serialize((Object)new boolean[]{true, false, true}));
        JSONSerializerTest.assertEquals((String)"[1.11]", (String)JSONSerializer.serialize((Object)new double[]{1.11}));
        JSONSerializerTest.assertEquals((String)"[1.11,2.22,3.33]", (String)JSONSerializer.serialize((Object)new double[]{1.11, 2.22, 3.33}));
        System.out.println(JSONSerializer.serialize((Object)new Test2()));
    }

    public void testToJson_bean() throws Exception {
        String s = JSONSerializer.serialize((Object)new MyBean());
        System.out.println(s);
        JSONSerializerTest.assertTrue((s.indexOf("aaa:null") > 0 ? 1 : 0) != 0);
        JSONSerializerTest.assertTrue((s.indexOf("bbb:null") > 0 ? 1 : 0) != 0);
        MyBean bean = new MyBean();
        bean.setBbb(new MyBean());
        s = JSONSerializer.serialize((Object)bean);
        System.out.println(s);
    }

    public void testToJson_htmlBean1() throws Exception {
        HtmlBean bean = new HtmlBean();
        String s = JSONSerializer.serialize((Object)bean);
        JSONSerializerTest.assertTrue((s.indexOf("status:null") > 0 ? 1 : 0) != 0);
        JSONSerializerTest.assertTrue((s.indexOf("html:null") > 0 ? 1 : 0) != 0);
    }

    public void testToJson_htmlBean2() throws Exception {
        HtmlBean bean = new HtmlBean();
        bean.setStatus(new Integer(30));
        bean.setHtml("<div>hoge</div>");
        String s = JSONSerializer.serialize((Object)bean);
        JSONSerializerTest.assertTrue((s.indexOf("status:30") > 0 ? 1 : 0) != 0);
        JSONSerializerTest.assertTrue((s.indexOf("html:\"<div>hoge<\\/div>\"") > 0 ? 1 : 0) != 0);
    }

    public void testQuote() throws Exception {
        JSONSerializerTest.assertEquals((String)"\"a\"", (String)JSONSerializer.quote((String)"a"));
        JSONSerializerTest.assertEquals((String)"\"\\t\"", (String)JSONSerializer.quote((String)"\t"));
        JSONSerializerTest.assertEquals((String)"\"\\n\"", (String)JSONSerializer.quote((String)"\n"));
        JSONSerializerTest.assertEquals((String)"\"\\u0000\"", (String)JSONSerializer.quote((String)"\u0000"));
        JSONSerializerTest.assertEquals((String)"\"\\\"\"", (String)JSONSerializer.quote((String)"\""));
        JSONSerializerTest.assertEquals((String)"\"\\\\\"", (String)JSONSerializer.quote((String)"\\"));
        JSONSerializerTest.assertEquals((String)"\"\\/\"", (String)JSONSerializer.quote((String)"/"));
    }

    public void testIsString() throws Exception {
        String s = "'aaa'";
        JSONSerializerTest.assertTrue((boolean)JSONSerializer.isString((String)s));
    }

    public void testIsString2() throws Exception {
        String s = "\"aaa\"";
        JSONSerializerTest.assertTrue((boolean)JSONSerializer.isString((String)s));
    }

    public void testIsString3() throws Exception {
        String s = "aaa";
        JSONSerializerTest.assertFalse((boolean)JSONSerializer.isString((String)s));
    }

    public void testIsObject1() {
        String str = "{'test1':'test2'}";
        boolean result = JSONSerializer.isObject((String)str);
        JSONSerializerTest.assertTrue((boolean)result);
    }

    public void testIsObject2() {
        String str = "['test1','test2']";
        boolean result = JSONSerializer.isObject((String)str);
        JSONSerializerTest.assertFalse((boolean)result);
    }

    public void testIsObject3() {
        String str = "'test2'";
        boolean result = JSONSerializer.isObject((String)str);
        JSONSerializerTest.assertFalse((boolean)result);
    }

    public void testIsArray1() {
        String str = "['test1','test2']";
        boolean result = JSONSerializer.isArray((String)str);
        JSONSerializerTest.assertTrue((boolean)result);
    }

    public void testIsArray2() {
        String str = "{'test1','test2'}";
        boolean result = JSONSerializer.isArray((String)str);
        JSONSerializerTest.assertFalse((boolean)result);
    }

    public void testIsArray3() {
        String str = "'test2'";
        boolean result = JSONSerializer.isArray((String)str);
        JSONSerializerTest.assertFalse((boolean)result);
    }

    public void testParseObject1() {
        String str = "{'test1':'test2'}";
        Map map = JSONSerializer.evalMap((String)str);
        JSONSerializerTest.assertEquals((String)"{test1=test2}", (String)map.toString());
    }

    public void testParseObject2() {
        String str = "{'test1':test2}";
        Map map = JSONSerializer.evalMap((String)str);
        JSONSerializerTest.assertEquals((String)"{test1=test2}", (String)map.toString());
    }

    public void testParseObject3() {
        String str = "{'test1':3}";
        Map map = JSONSerializer.evalMap((String)str);
        Integer i = (Integer)map.get("test1");
        JSONSerializerTest.assertEquals((Object)i, (Object)new Integer(3));
    }

    public void testParseObject4() {
        String str = "{'test1':'4'}";
        Map map = JSONSerializer.evalMap((String)str);
        String i = (String)map.get("test1");
        JSONSerializerTest.assertEquals((String)i, (String)"4");
    }

    public void testParseObject5() {
        String str = "{'test2':{'test1':'5'}}";
        Map map = JSONSerializer.evalMap((String)str);
        Map m = (Map)map.get("test2");
        JSONSerializerTest.assertNotNull((Object)m);
        String s = (String)m.get("test1");
        JSONSerializerTest.assertEquals((String)s, (String)"5");
    }

    public void testParseObject6() {
        String str = "{'test1':{'test2':'2'},'test3':{'test4':'4'}}";
        Map map = JSONSerializer.evalMap((String)str);
        JSONSerializerTest.assertEquals((String)"{test3={test4=4}, test1={test2=2}}", (String)map.toString());
    }

    public void testParseArray1() {
        String str = "['test1']";
        List list = JSONSerializer.evalArray((String)str);
        JSONSerializerTest.assertEquals((Object)"test1", list.get(0));
    }

    public void testParseArray2() {
        String str = "['test1', 'test2']";
        List list = JSONSerializer.evalArray((String)str);
        JSONSerializerTest.assertEquals((Object)"test1", list.get(0));
        JSONSerializerTest.assertEquals((Object)"test2", list.get(1));
    }

    public void testParseArray3() {
        String str = "[1, 2]";
        List list = JSONSerializer.evalArray((String)str);
        JSONSerializerTest.assertEquals((Object)new Integer(1), list.get(0));
        JSONSerializerTest.assertEquals((Object)new Integer(2), list.get(1));
    }

    public void testParseArray4() {
        String str = "[1, [2, 3, 4, 5], 3]";
        List list = JSONSerializer.evalArray((String)str);
        JSONSerializerTest.assertEquals((Object)new Integer(1), list.get(0));
        JSONSerializerTest.assertEquals((String)list.toString(), (String)"[1, [2, 3, 4, 5], 3]");
    }

    public void testParseArray5() {
        String str = "[{'test1':1}, {'test2':'2'}]";
        List list = JSONSerializer.evalArray((String)str);
        Map map1 = (Map)list.get(0);
        Integer i = (Integer)map1.get("test1");
        JSONSerializerTest.assertEquals((Object)i, (Object)new Integer(1));
        Map map2 = (Map)list.get(1);
        String s = (String)map2.get("test2");
        JSONSerializerTest.assertEquals((String)s, (String)"2");
    }

    public void testParseArray6() {
        String str = "[{'test1':{'test2':'2'},'test3':{'test4':'4'}}]";
        List list = JSONSerializer.evalArray((String)str);
        JSONSerializerTest.assertEquals((String)"[{test3={test4=4}, test1={test2=2}}]", (String)list.toString());
    }

    public static class Hoge3 {
        private List list = new ArrayList();

        public Hoge3() {
            HashMap<String, Object[]> child1 = new HashMap<String, Object[]>();
            child1.put("aaa", new String[]{"aaa", "bbb", "ccc"});
            child1.put("ccc", new Integer[]{new Integer(1), new Integer(2)});
            this.list.add(child1);
            HashMap<String, String[]> child2 = new HashMap<String, String[]>();
            child2.put("bbb", new String[]{"AAA", "BBB", "CCC"});
            this.list.add(child2);
        }

        public List getList() {
            return this.list;
        }

        public void setList(List list) {
            this.list = list;
        }
    }

    public static class Hoge2 {
        private Map map = new HashMap();

        public Hoge2() {
            HashMap<String, Object[]> child1 = new HashMap<String, Object[]>();
            child1.put("aaa", new String[]{"aaa", "bbb", "ccc"});
            child1.put("ccc", new Integer[]{new Integer(1), new Integer(2)});
            HashMap<String, String[]> child2 = new HashMap<String, String[]>();
            child2.put("bbb", new String[]{"AAA", "BBB", "CCC"});
            this.map.put("maplist", new Map[]{child1, child2});
        }

        public Map getMap() {
            return this.map;
        }

        public void setMap(Map map) {
            this.map = map;
        }
    }

    public static class Hoge {
        private Map map = new HashMap();

        public Hoge() {
            HashMap<String, String[]> child1 = new HashMap<String, String[]>();
            child1.put("aaa", new String[]{"aaa", "bbb", "ccc"});
            HashMap<String, String[]> child2 = new HashMap<String, String[]>();
            child2.put("bbb", new String[]{"AAA", "BBB", "CCC"});
            this.map.put("maplist", new Map[]{child1, child2});
        }

        public Map getMap() {
            return this.map;
        }

        public void setMap(Map map) {
            this.map = map;
        }
    }

    public static class HtmlBean {
        private Integer status;
        private String html;

        public String getHtml() {
            return this.html;
        }

        public void setHtml(String html) {
            this.html = html;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }
    }

    public static class Test2 {
        private int[] bbb = new int[]{11, 22, 33};
        private boolean[] ccc = new boolean[]{true, false, true};
        private double[] ddd = new double[]{1.11, 2.22, 3.33};

        public int[] getBbb() {
            return this.bbb;
        }

        public boolean[] getCcc() {
            return this.ccc;
        }

        public double[] getDdd() {
            return this.ddd;
        }
    }

    public static class Test1 {
        private String aaa = "hoge";
        private int bbb = 100;
        private boolean ccc = true;
        private double ddd = 3.14;

        public String getAaa() {
            return this.aaa;
        }

        public int getBbb() {
            return this.bbb;
        }

        public boolean isCcc() {
            return this.ccc;
        }

        public double getDdd() {
            return this.ddd;
        }
    }

    public static class MyBean {
        private String aaa;
        private MyBean bbb;

        public String getAaa() {
            return this.aaa;
        }

        public void setAaa(String aaa) {
            this.aaa = aaa;
        }

        public MyBean getBbb() {
            return this.bbb;
        }

        public void setBbb(MyBean bbb) {
            this.bbb = bbb;
        }
    }
}

