/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.seasar.teeda.core.util.PatternUtil;

public class PatternUtilTest
extends TestCase {
    public void testMatches_normal() throws Exception {
        PatternUtilTest.assertTrue((boolean)PatternUtil.matches((String)"^[1-9][a-z]", (CharSequence)"1a"));
    }

    public void testMatches_regexMustNotNull() throws Exception {
        try {
            PatternUtil.matches(null, (CharSequence)"1a");
        }
        catch (IllegalArgumentException expected) {
            PatternUtilTest.assertTrue((boolean)true);
        }
    }

    public void testGetPattern_ensureCacheWork() throws Exception {
        Pattern p = Pattern.compile("^[1-9][a-z]");
        Pattern p1 = PatternUtil.getPattern((String)"^[1-9][a-z]");
        Pattern p2 = PatternUtil.getPattern((String)"^[1-9][a-z]");
        PatternUtilTest.assertNotSame((Object)p, (Object)p1);
        PatternUtilTest.assertEquals((Object)p1, (Object)p2);
    }

    public void testClearPatternCache() throws Exception {
        Pattern p1 = PatternUtil.getPattern((String)"^[1-9][a-z]");
        Pattern p2 = PatternUtil.getPattern((String)"^[1-9][a-z]");
        PatternUtilTest.assertEquals((Object)p1, (Object)p2);
        PatternUtil.clearPatternCache();
        Pattern p3 = PatternUtil.getPattern((String)"^[1-9][a-z]");
        PatternUtilTest.assertNotSame((Object)p1, (Object)p3);
        PatternUtilTest.assertNotSame((Object)p2, (Object)p3);
    }
}

