/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlGraphicImage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import org.custommonkey.xmlunit.Diff;
import org.seasar.teeda.core.mock.MockApplicationImpl;
import org.seasar.teeda.core.mock.MockExternalContext;
import org.seasar.teeda.core.mock.MockExternalContextWrapper;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockViewHandlerImpl;
import org.seasar.teeda.core.render.html.HtmlGraphicImageRenderer;

public class HtmlGraphicImageRendererTest
extends RendererTest {
    private HtmlGraphicImageRenderer renderer;
    private MockHtmlGraphicImage htmlGraphicImage;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlGraphicImageRenderer();
        this.htmlGraphicImage = new MockHtmlGraphicImage();
        this.htmlGraphicImage.setRenderer((Renderer)this.renderer);
    }

    public void testEncode_WithNoValue() throws Exception {
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlGraphicImage);
        HtmlGraphicImageRendererTest.assertEquals((String)"<img src=\"\" />", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlGraphicImage.setRendered(false);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlGraphicImage);
        HtmlGraphicImageRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_WithValue() throws Exception {
        this.htmlGraphicImage.setValue("abc");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlGraphicImage);
        HtmlGraphicImageRendererTest.assertEquals((String)"<img src=\"abc\" />", (String)this.getResponseText());
    }

    public void testEncode_WithValueContainsAmpersand() throws Exception {
        this.htmlGraphicImage.setValue("a?a=b&c=d");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlGraphicImage);
        HtmlGraphicImageRendererTest.assertEquals((String)"<img src=\"a?a=b&amp;c=d\" />", (String)this.getResponseText());
    }

    public void testEncode_WithId() throws Exception {
        this.htmlGraphicImage.setId("a");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlGraphicImage);
        HtmlGraphicImageRendererTest.assertEquals((String)"<img id=\"a\" src=\"\" />", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute() throws Exception {
        this.htmlGraphicImage.setId("a");
        this.htmlGraphicImage.getAttributes().put("a", "1");
        this.htmlGraphicImage.getAttributes().put("b", "2");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlGraphicImage);
        Diff diff = this.diff("<img id=\"a\" src=\"\" a=\"1\" b=\"2\" />", this.getResponseText());
        HtmlGraphicImageRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testEncode_border() throws Exception {
        this.htmlGraphicImage.setId("a");
        this.htmlGraphicImage.setBorder(10);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlGraphicImage);
        String responseText = this.getResponseText();
        System.out.println(responseText);
        Diff diff = this.diff("<img id=\"a\" src=\"\" border=\"10\" />", responseText);
        HtmlGraphicImageRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testEncode_UrlEncode() throws Exception {
        MockFacesContext context = this.getFacesContext();
        MockExternalContextWrapper externalContext = new MockExternalContextWrapper((MockExternalContext)context.getExternalContext()){

            public String encodeResourceURL(String url) {
                return url + "_2";
            }
        };
        MockApplicationImpl application = new MockApplicationImpl(){

            public ViewHandler getViewHandler() {
                return new MockViewHandlerImpl(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public String getResourceURL(FacesContext context, String path) {
                        return path + "_1";
                    }
                };
            }
        };
        context.setApplication((Application)application);
        context.setExternalContext((ExternalContext)externalContext);
        this.htmlGraphicImage.setValue("abc");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlGraphicImage);
        HtmlGraphicImageRendererTest.assertEquals((String)"<img src=\"abc_1_2\" />", (String)this.getResponseText());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        this.htmlGraphicImage.setAlt("a");
        this.htmlGraphicImage.setDir("b");
        this.htmlGraphicImage.setHeight("c");
        this.htmlGraphicImage.setIsmap(true);
        this.htmlGraphicImage.setLang("e");
        this.htmlGraphicImage.setLongdesc("f");
        this.htmlGraphicImage.setOnclick("g");
        this.htmlGraphicImage.setOndblclick("h");
        this.htmlGraphicImage.setOnkeydown("i");
        this.htmlGraphicImage.setOnkeypress("j");
        this.htmlGraphicImage.setOnkeyup("k");
        this.htmlGraphicImage.setOnmousedown("l");
        this.htmlGraphicImage.setOnmousemove("m");
        this.htmlGraphicImage.setOnmouseout("n");
        this.htmlGraphicImage.setOnmouseover("o");
        this.htmlGraphicImage.setOnmouseup("p");
        this.htmlGraphicImage.setStyle("q");
        this.htmlGraphicImage.setStyleClass("r");
        this.htmlGraphicImage.setTitle("s");
        this.htmlGraphicImage.setUsemap("t");
        this.htmlGraphicImage.setWidth("u");
        this.htmlGraphicImage.setId("A");
        this.htmlGraphicImage.setValue("B");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlGraphicImage);
        Diff diff = new Diff("<img id=\"A\" src=\"B\" alt=\"a\" dir=\"b\" height=\"c\" ismap=\"true\" lang=\"e\" longdesc=\"f\" onclick=\"g\" ondblclick=\"h\" onkeydown=\"i\" onkeypress=\"j\" onkeyup=\"k\" onmousedown=\"l\" onmousemove=\"m\" onmouseout=\"n\" onmouseover=\"o\" onmouseup=\"p\" style=\"q\" class=\"r\" title=\"s\" usemap=\"t\" width=\"u\"/>", this.getResponseText());
        HtmlGraphicImageRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testGetRendersChildren() throws Exception {
        HtmlGraphicImageRendererTest.assertEquals((boolean)false, (boolean)this.renderer.getRendersChildren());
    }

    private HtmlGraphicImageRenderer createHtmlGraphicImageRenderer() {
        return (HtmlGraphicImageRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlGraphicImageRenderer renderer = new HtmlGraphicImageRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }

    private static class MockHtmlGraphicImage
    extends HtmlGraphicImage {
        private Renderer renderer_;
        private String clientId_;

        private MockHtmlGraphicImage() {
        }

        public void setRenderer(Renderer renderer) {
            this.renderer_ = renderer;
        }

        protected Renderer getRenderer(FacesContext context) {
            if (this.renderer_ != null) {
                return this.renderer_;
            }
            return super.getRenderer(context);
        }

        public String getClientId(FacesContext context) {
            if (this.clientId_ != null) {
                return this.clientId_;
            }
            return super.getClientId(context);
        }

        public void setClientId(String clientId) {
            this.clientId_ = clientId;
        }
    }
}

