/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.validator.AbstractValidatorTest;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockUIComponent;

public class LengthValidatorTest
extends AbstractValidatorTest {
    public void testConstants() throws Exception {
        LengthValidatorTest.assertEquals((String)"javax.faces.validator.LengthValidator.MAXIMUM", (String)"javax.faces.validator.LengthValidator.MAXIMUM");
        LengthValidatorTest.assertEquals((String)"javax.faces.validator.LengthValidator.MINIMUM", (String)"javax.faces.validator.LengthValidator.MINIMUM");
        LengthValidatorTest.assertEquals((String)"javax.faces.Length", (String)"javax.faces.Length");
    }

    public void testGetMaximum_maxNotSet() throws Exception {
        LengthValidator validator = new LengthValidator();
        LengthValidatorTest.assertEquals((int)-1, (int)validator.getMaximum());
    }

    public void testGetMaximum_getMax() throws Exception {
        LengthValidator validator = new LengthValidator(5);
        LengthValidatorTest.assertEquals((int)5, (int)validator.getMaximum());
    }

    public void testGetMinimum_minNotSet() throws Exception {
        LengthValidator validator = new LengthValidator();
        LengthValidatorTest.assertEquals((int)-1, (int)validator.getMinimum());
    }

    public void testGetMinimum_getMin() throws Exception {
        LengthValidator validator = new LengthValidator(5, 2);
        LengthValidatorTest.assertEquals((int)2, (int)validator.getMinimum());
    }

    public void testValidate_lengthLessThanMin() throws Exception {
        FacesContext context = this.getFacesContextWithSetMessageBundle("a", Locale.ENGLISH);
        LengthValidator validator = new LengthValidator(5, 2);
        try {
            validator.validate(context, (UIComponent)context.getViewRoot(), (Object)"b");
            LengthValidatorTest.fail();
        }
        catch (ValidatorException expected) {
            LengthValidatorTest.assertEquals((String)"length less than min(2,a)", (String)expected.getMessage());
            LengthValidatorTest.success();
        }
    }

    public void testValidate_lengthMoreThanMax() throws Exception {
        FacesContext context = this.getFacesContextWithSetMessageBundle("a", Locale.ENGLISH);
        LengthValidator validator = new LengthValidator(5, 2);
        try {
            validator.validate(context, (UIComponent)context.getViewRoot(), (Object)"123456");
            LengthValidatorTest.fail();
        }
        catch (ValidatorException expected) {
            LengthValidatorTest.assertEquals((String)"length more than max(5,a)", (String)expected.getMessage());
            LengthValidatorTest.success();
        }
    }

    public void testValidate_NoValidate() throws Exception {
        MockFacesContext context = this.getFacesContext();
        LengthValidator validator = new LengthValidator(5, 2);
        validator.validate((FacesContext)context, (UIComponent)new MockUIComponent(), (Object)"");
    }

    protected FacesContext getFacesContextWithSetMessageBundle(String viewRootId, Locale locale) {
        this.getApplication().setMessageBundle("javax.faces.component.TestMessages");
        MockFacesContext context = this.getFacesContext();
        UIViewRoot root = new UIViewRoot();
        root.setId(viewRootId);
        root.setLocale(locale);
        context.setViewRoot(root);
        return context;
    }

    protected Validator createValidator() {
        return new LengthValidator();
    }
}

